<?php
/**
 * Single Product tabs
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     3.8.0
 */

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Filter tabs and allow third parties to add their own
 *
 * Each tab is an array containing title, callback and priority.
 * @see woocommerce_default_product_tabs()
 */
$tabs = apply_filters( 'woocommerce_product_tabs', array() );

if ( ! empty( $tabs ) ) : ?>

	<div class="cart-single-tab">
            <ul class="nav nav-tabs">
            	<?php $i=1;?>
                <?php foreach ( $tabs as $key => $tab ) : ?>
    				 <li class="<?php echo ($i==1) ? 'active' : '';?>"><a data-toggle="tab" href="#tab-<?php echo $key ?>"><?php echo apply_filters( 'woocommerce_product_' . $key . '_tab_title', $tab['title'], $key ) ?></a></li>
    				<?php $i++;?>
                <?php endforeach; ?>
            </ul>
            <div class="tab-content">
				<?php $i=1;?>
                <?php foreach ( $tabs as $key => $tab ) : ?>
                    <div id="tab-<?php echo $key ?>" class="tab-pane fade <?php echo ($i==1) ? 'active in' : '';?>">
                    
                        <?php call_user_func( $tab['callback'], $key, $tab ) ?>
                    </div>
                    <?php $i++;?>
                <?php endforeach; ?>
       		</div>
        
	</div>
    
<?php endif; ?>