<?php
/**
 * The Template for displaying all single products.
 *
 * Override this template by copying it to yourtheme/woocommerce/single-product.php
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     2.4.12
 */

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

get_header('shop'); ?>
<?php 
	$PageSettings  = get_post_meta(get_the_ID(), 'sh_product_meta', true);
	$meta = sh_set(sh_set($PageSettings, 'sh_product_options'), 0);
	$bg = (sh_set($meta, 'header_image')) ? 'style="background:url('.sh_set($meta, 'header_image').');"' : '';
?>

<section class="block inner-head-sec">
	<div class="dark">
		<div class="fixed-img sec-bg8" <?php echo $bg;?>></div> 
		<div class="container">
			<div class="inner-head">
            	<h2><?php echo sh_set($meta, 'sub_title'); ?></h2>
            	<?php echo get_the_breadcrumb();?>
			</div>
		</div>
	</div>
</section><!-- Inner Head -->

<section class="block">
	<div class="container">
		<div class="row">
       		<?php if(sh_set($meta, 'layout') == 'left'):?>
            
            	<aside class="col-md-3 slideinleft">
                        <?php dynamic_sidebar( sh_set($meta, 'sidebar', 'blog-sidebar') ); ?>
                   
            	</aside>
            
            <?php endif;?>
			
			 <div class=" <?php echo (sh_set($meta, 'layout') == 'full' || sh_set($meta, 'layout') == '') ? 'col-md-12' : 'col-md-9'?>">
                <div class="inner-left">
					
					<?php
                        /**
                         * woocommerce_before_main_content hook
                         *
                         * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
                         * @hooked woocommerce_breadcrumb - 20
                         */
                        do_action('woocommerce_before_main_content');
                    ?>
                
                        <?php while ( have_posts() ) : the_post(); ?>
                
                            <?php wc_get_template_part( 'content', 'single-product' ); ?>
                
                        <?php endwhile; // end of the loop. ?>
                
                    <?php
						do_action( 'woocommerce_after_single_product_summary' );
                        /**
                         * woocommerce_after_main_content hook
                         *
                         * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
                         */
                        do_action('woocommerce_after_main_content');
                    ?>
                    
                </div>
        	 </div>
            
            <?php if(sh_set($meta, 'layout') == 'right'):?>
            
            	<aside class="col-md-3 slideinright">
                        <?php dynamic_sidebar( sh_set($meta, 'sidebar', 'blog-sidebar') ); ?>
                </aside>
            
            <?php endif;?>
            
    	</div>
    </div>
</section>

<script type="text/javascript">
	jQuery(document).ready(function($) {
        $("#cart-slide").owlCarousel({
			autoPlay :true,
			stopOnHover : true,
			goToFirstSpeed : 2000,
			slideSpeed:1500,
			singleItem : true,
			autoHeight : true,
			transitionStyle:"goDown",
			navigation:false
		});	
    });
</script>
<?php wp_enqueue_script('increment-sript');?>
<script type="text/javascript">
	jQuery(document).ready(function($){
		if($(".manual-adjust").length){
        $(".manual-adjust").userincr({
			buttonlabels:{'dec':'-','inc':'+'},
			}).data({'min':0,'max':20,'step':1});
		}
		
    });
</script>

<?php get_footer('shop'); ?>