<?php
/**
 * The template for displaying product content in the single-product.php template
 *
 * Override this template by copying it to yourtheme/woocommerce/content-single-product.php
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     3.6.0
 */

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
?>

<?php
	/**
	 * woocommerce_before_single_product hook
	 *
	 * @hooked woocommerce_show_messages - 10
	 */
	 do_action( 'woocommerce_before_single_product' );

?>
<?php $settings = get_option( 'wp_dastak'.'_theme_options' );?>


	<div id="cart-single-sec" <?php post_class(); ?>>
        <div class="row">
            <div class="col-md-5">
                <?php   /**
                     * woocommerce_show_product_images hook
                     *
                     * @hooked woocommerce_show_product_sale_flash - 10
                     * @hooked woocommerce_show_product_images - 20
                     */
                    do_action( 'woocommerce_before_single_product_summary' );
                ?>
                <!--<ul id="cart-slide">
                    <li><img src="http://placehold.it/570x380" alt="" /></li>
                    <li><img src="http://placehold.it/570x380" alt="" /></li>
                    <li><img src="http://placehold.it/570x380" alt="" /></li>
                </ul>-->
                <?php  if(sh_set($settings, 'enable_product_single_wishlist')) : ?>
	                <div class="product-single-btns">
	                    <a class="whishlist-btn add_to_wishlist" data-id="<?php echo esc_attr(get_the_ID());?>" title="" href="javascript:void(0);"><i class="fa fa-heart"></i></a>
	                </div>
	            <?php endif; ?>
            </div>
            <div class="col-md-7">
                <div class="cart-product-desc">
                	<?php woocommerce_template_single_rating(); ?>
                    <h3><?php the_title();?></h3>
                    <?php woocommerce_template_single_price(); ?>
                    
                    
                    
                     <?php woocommerce_template_single_add_to_cart(); 
						$compare_page_template = array('post_type' => 'page', 'meta_key' => '_wp_page_template','meta_value' => 'tpl-compare.php');
						$compare_page = get_pages( $compare_page_template );//printr($compare_page);
						?>
						<?php if( $compare_page ):
		
							$compare_link = add_query_arg( 
								array('product_id'=>get_the_id()),
								get_permalink(sh_set(sh_set( $compare_page, 0 ) , 'ID'))
							); ?>
							
							<a title="" href="<?php echo str_replace('&', '&amp;', $compare_link); ?>"><?php _e("Add to Compare" , 'wp_dastak'); ?></a>
		
						<?php endif; ?>
                        <?php the_excerpt(); ?>
                </div>
            </div>
            
        </div>
	</div>
    
    <?php
		/**
		 * woocommerce_single_product_summary hook
		 *
		 * @hooked woocommerce_template_single_title - 5
		 * @hooked woocommerce_template_single_price - 10
		 * @hooked woocommerce_template_single_excerpt - 20
		 * @hooked woocommerce_template_single_add_to_cart - 30
		 * @hooked woocommerce_template_single_meta - 40
		 * @hooked woocommerce_template_single_sharing - 50
		 */
		do_action( 'woocommerce_single_product_summary' );
	?>
    
	<?php
		/**
		 * woocommerce_after_single_product_summary hook
		 *
		 * @hooked woocommerce_output_product_data_tabs - 10
		 * @hooked woocommerce_output_related_products - 20
		 */
		//do_action( 'woocommerce_after_single_product_summary' );
	?>
<?php do_action( 'woocommerce_after_single_product' ); ?>