<?php
/**
 * The template for displaying product content within loops.
 *
 * Override this template by copying it to yourtheme/woocommerce/content-product.php
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     2.4.12
 */

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly ?>
<?php $settings = get_option( 'wp_dastak'.'_theme_options' );?>
<div class="top-margin">
	<div class="row">
			<?php while( have_posts() ): the_post();
            
                global $product, $woocommerce_loop;
                
                // Store loop count we're currently on
                if ( empty( $woocommerce_loop['loop'] ) )
                    $woocommerce_loop['loop'] = 0;
                
                // Store column count for displaying the grid
                if ( empty( $woocommerce_loop['columns'] ) )
                    $woocommerce_loop['columns'] = apply_filters( 'loop_shop_columns', 4 );
                
                // Ensure visibility
                if ( ! $product || ! $product->is_visible() )
                    return;
                
                // Increase loop count
                $woocommerce_loop['loop']++;
                
                // Extra post classes
                $classes = array();
                if ( 0 == ( $woocommerce_loop['loop'] - 1 ) % $woocommerce_loop['columns'] || 1 == $woocommerce_loop['columns'] )
                    $classes[] = 'first';
               if ( 0 == $woocommerce_loop['loop'] % $woocommerce_loop['columns'] )
					$classes[] = 'last';
				if(sh_set($settings, 'product_page_cols')) $classes[] = 'col-md-'.sh_set($settings, 'product_page_cols');
				else $classes[] = 'col-md-3';
                ?>
                
           <?php if(sh_set($settings, 'product_page_style') == 2):?>
        	<div <?php post_class( $classes ); ?>>
                <div class="shop">
                    <div class="shop-img">
                         <?php $hover_image = '';
                            $attachments = get_posts( array( 'post_type'=>'attachment', 'post_parent'=>get_the_id(), 'posts_per_page'=>1 ) );
                            if( $attachments ) $hover_image = wp_get_attachment_image( sh_set( $attachments[0], 'ID' ), '289x359', '', array( 'class' => 'hover-show' ) );
							else $hover_image = get_the_post_thumbnail( get_the_ID(), '289x359', array('class'=>'hover-show') );
    
                            echo ( has_post_thumbnail() ? get_the_post_thumbnail( get_the_ID(), '289x359', array('class'=>'seller-still') ) : woocommerce_placeholder_img( '289x359' ) ); ?>
                            
                            <?php echo $hover_image; ?>
                            <?php $product_price = sh_woocommerce_price_array($product->get_price_html());?>
                        <div class="price-holder">
                            <div class="shop-price">
                                <h6><?php echo sh_set($product_price, 0);?></h6>
                                <ul>
                                    <li><?php 
                    					 $add_to_cart = '';
											if ($product->is_purchasable() && $product->is_in_stock()) {
												if (get_option('woocommerce_enable_ajax_add_to_cart') == 'yes') {
													$add_to_cart = 'add_to_cart_button ajax_add_to_cart';
												} else {
													$add_to_cart = 'add_to_cart_button';
												}
											}
                                        echo apply_filters( 'woocommerce_loop_add_to_cart_link',
                                            sprintf( '<a href="%s" rel="nofollow" data-product_id="%s" data-product_sku="%s" class="%s product_type_%s"><i class="fa fa-shopping-cart"></i></a>',
                                                esc_url( $product->add_to_cart_url() ),
                                                esc_attr( $product->get_id() ),
                                                esc_attr( $product->get_sku() ),
                                                $add_to_cart,
                                                esc_attr( $product->get_type() ),
                                                esc_html( $product->add_to_cart_text() )
                                            ),
                                        $product ); 
                                        
                                    ?></li>
                                    <li><a href="javascript:void(0);" data-id="<?php the_ID(); ?>" class="add_to_wishlist"><i class="fa fa-heart"></i></a></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <h3><a href="<?php the_permalink();?>" title="<?php the_title();?>"><?php the_title();?></a></h3>
                    <p><?php echo character_limiter( get_the_content(), 30, '', true ); ?></p>
                    <ul class="social-btns">
                        <li><a href="http://www.facebook.com/sharer/sharer.php?u=<?php echo urlencode(get_permalink()); ?>" title="<?php _e('Facebook', 'wp_dastak');?>"><i class="fa fa-facebook"></i></a></li>
                        <li><a href="https://plusone.google.com/_/+1/confirm?hl=en&amp;url=<?php echo urlencode(get_permalink()); ?>" title="<?php _e('Google Plus', 'wp_dastak');?>"><i class="fa fa-google-plus"></i></a></li>
                        <li><a href="http://twitter.com/share?text=<?php echo strip_tags(get_the_excerpt());?>&amp;url=<?php echo urlencode(get_permalink()); ?>" title="<?php _e('Twitter', 'wp_dastak');?>"><i class="fa fa-twitter"></i></a></li>
                        <li><a href="javascript:void((function()%7Bvar%20e=document.createElement(&apos;script&apos;);e.setAttribute(&apos;type&apos;,&apos;text/javascript&apos;);e.setAttribute(&apos;charset&apos;,&apos;UTF-8&apos;);e.setAttribute(&apos;src&apos;,&apos;http://assets.pinterest.com/js/pinmarklet.js?r=&apos;+Math.random()*99999999);document.body.appendChild(e)%7D)());" title="<?php _e('Pinterest', 'wp_dastak');?>"><i class="fa fa-pinterest"></i></a></li>
                        <li><a href="#" title=""><i class="fa fa-skype"></i></a></li>
                    </ul>				
                </div>
            </div>
        <?php else:?>
            <div <?php post_class( $classes ); ?>>
                <div class="trend">
                    <div class="trend-img">
                        <?php the_post_thumbnail('289x359'); ?>
                         <?php woocommerce_template_loop_price(); ?>
                        <a href="javascript:void(0);" data-id="<?php the_ID(); ?>" class="add-to-fav add_to_wishlist"><i class="fa fa-heart"></i></a>
                    </div>
                    <h3><a href="<?php the_permalink();?>"><?php the_title();?></a></h3>
                    <p><?php echo character_limiter( get_the_content(), 25, '', true ); ?></p>
                    <?php 
                        $add_to_cart = '';
						if ($product->is_purchasable() && $product->is_in_stock()) {
							if (get_option('woocommerce_enable_ajax_add_to_cart') == 'yes') {
								$add_to_cart = 'add_to_cart_button ajax_add_to_cart';
							} else {
								$add_to_cart = 'add_to_cart_button';
							}
						}
                        echo apply_filters( 'woocommerce_loop_add_to_cart_link',
                            sprintf( '<a href="%s" rel="nofollow" data-product_id="%s" data-product_sku="%s" class="%s product_type_%s">'.__('Add to Cart', 'wp_dastak').'</a>',
                                esc_url( $product->add_to_cart_url() ),
                                esc_attr( $product->get_id() ),
                                esc_attr( $product->get_sku() ),
                                $add_to_cart,
                                esc_attr( $product->get_type() ),
                                esc_html( $product->add_to_cart_text() )
                            ),
                        $product ); 
                        
                    ?>
                </div>
            </div>
        <?php endif;?>          
            
            <?php endwhile; ?>
	
</div>
</div>