<?php
/**
 * Cart Page
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     3.8.0
 */

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

global $woocommerce, $wp_query; //printr($wp_query); ?>

	<?php 
	 	wc_print_notices();
        do_action( 'woocommerce_before_cart' ); 
	?>
      
    <form action="<?php echo esc_url( wc_get_cart_url() ); ?>" method="post">
        <ul class="cart-sec">
            <?php do_action( 'woocommerce_before_cart_table' ); ?>
            <?php do_action( 'woocommerce_before_cart_contents' ); ?>
            <?php
                foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {
                    $_product     = apply_filters( 'woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key );
                    $product_id   = apply_filters( 'woocommerce_cart_item_product_id', $cart_item['product_id'], $cart_item, $cart_item_key );
        
                    if ( $_product && $_product->exists() && $cart_item['quantity'] > 0 && apply_filters( 'woocommerce_cart_item_visible', true, $cart_item, $cart_item_key ) ) {
            ?>
                    <li class="<?php echo esc_attr( apply_filters( 'woocommerce_cart_item_class', 'cart_item', $cart_item, $cart_item_key ) ); ?>">
                        <div class="product">
                            <span>
                                <?php
                                    $thumbnail = get_the_post_thumbnail( $product_id, '370x370' ); 

                                    if ( ! $_product->is_visible() )
                                        echo $thumbnail;
                                    else
                                        printf( '%s', $thumbnail );
                                ?>


                                <?php
                                    echo apply_filters( 'woocommerce_cart_item_remove_link', sprintf( '<a href="%s" class="remove" title="%s"><i class="fa fa-trash-o"></i></a>', esc_url( wc_get_cart_remove_url( $cart_item_key ) ), __( 'Remove this item', 'wp_dastak' ) ), $cart_item_key );
                                ?>
                            </span>
                            <?php
                                    if ( ! $_product->is_visible() )
                                            echo '<h3>'.apply_filters( 'woocommerce_cart_item_name', $_product->get_title(), $cart_item, $cart_item_key ).'</h3>';
                                    else
                                            echo apply_filters( 'woocommerce_cart_item_name', sprintf( '<h3>%s</h3>', $_product->get_title() ), $cart_item, $cart_item_key );

                                    // Meta data
                                    echo wc_get_formatted_cart_item_data( $cart_item );

                                    // Backorder notification
                                    if ( $_product->backorders_require_notification() && $_product->is_on_backorder( $cart_item['quantity'] ) )
                                            echo '<p class="backorder_notification">' . __( 'Available on backorder', 'wp_dastak' ) . '</p>';
                            ?>

                        </div><!-- Product Detals -->

                        <div class="price">
                            <span><?php _e('PRICE', 'wp_dastak');?></span>
                            <h3><?php
                                    echo apply_filters( 'woocommerce_cart_item_price', WC()->cart->get_product_price( $_product ), $cart_item, $cart_item_key );
                                ?></h3>
                        </div><!-- price Detals -->

                        <div class="cart-quantity">
                            <span><?php _e('Quantity', 'wp_dastak');?></span>
                            <div class="decrements">

                               <?php
                                        if ( $_product->is_sold_individually() ) {
                                                $product_quantity = sprintf( '1 <input type="hidden" name="cart[%s][qty]" value="1" />', $cart_item_key );
                                        } else {
                                                $product_quantity = woocommerce_quantity_input( array(
                                                        'input_name'  => "cart[{$cart_item_key}][qty]",
                                                        'input_value' => $cart_item['quantity'],
                                                        'max_value'   => $_product->backorders_allowed() ? '' : $_product->get_stock_quantity(),
                                                        'min_value'   => '0'
                                                ), $_product, false );
                                        }

                                        echo apply_filters( 'woocommerce_cart_item_quantity', $product_quantity, $cart_item_key, $cart_item );
                                ?>

                            </div>
                        </div><!-- quantity Detals -->

                        <div class="total">
                            <span><?php _e('TOTAL', 'wp_dastak');?></span>
                            <h3><?php
                                    echo apply_filters( 'woocommerce_cart_item_subtotal', WC()->cart->get_product_subtotal( $_product, $cart_item['quantity'] ), $cart_item, $cart_item_key );
                                ?>
                            </h3>
                        </div><!-- price Detals -->
                    </li>	
            
            <?php
                }
            }
    
            do_action( 'woocommerce_cart_contents' );
            ?>
         </ul>
          <?php if ( WC()->cart->coupons_enabled() ) { ?>
                <div class="coupon">

                    <label for="coupon_code"><?php _e( 'Coupon', 'wp_dastak' ); ?>:</label> <input type="text" name="coupon_code" class="input-text" id="coupon_code" value="" placeholder="<?php _e( 'Coupon code', 'wp_dastak' ); ?>" /> <input type="submit" class="button" name="apply_coupon" value="<?php _e( 'Apply Coupon', 'wp_dastak' ); ?>" />

                    <?php do_action('woocommerce_cart_coupon'); ?>

                </div>
            <?php } ?>

            <input type="submit" class="button" name="update_cart" value="<?php _e( 'Update Cart', 'wp_dastak' ); ?>" /> <input type="submit" class="checkout-button button alt wc-forward" name="proceed" value="<?php _e( 'Proceed to Checkout', 'wp_dastak' ); ?>" />

            <?php //do_action( 'woocommerce_proceed_to_checkout' ); ?>

            <?php wp_nonce_field( 'woocommerce-cart' ); ?>
            
            <?php do_action( 'woocommerce_after_cart_contents'); ?>
               
            <?php do_action( 'woocommerce_after_cart_table' ); ?>
        </form>
    
  	<?php //do_action( 'woocommerce_cart_collaterals' ); ?>
	<div class="row">
        <div class="col-md-6">
        <?php woocommerce_cart_totals(); ?>
        </div>
        
        <div class="col-md-6">
            <?php woocommerce_shipping_calculator(); ?>
        </div>
    </div>
	<?php do_action( 'woocommerce_after_cart' ); ?>
<?php wp_enqueue_script('increment-sript');?>
<script type="text/javascript">
	jQuery(document).ready(function($){
		if($(".manual-adjust").length){
        $(".manual-adjust").userincr({
			buttonlabels:{'dec':'-','inc':'+'},
			}).data({'min':0,'max':20,'step':1});
		}
		
    });
</script>