<?php get_header();?>
<?php 
	$meta_settings  = get_post_meta($post->ID, 'sh_team_meta', true);
	$page_options = sh_set($meta_settings['sh_page_options'][0], 'designation' );
	$team_skills = sh_set($meta_settings, 'sh_team_skills_options');
	$tema_eperiences = sh_set($meta_settings, 'sh_team_experience_options');
?>

<section class="block inner-head-sec">
	<div class="dark">
		<div class="fixed-img sec-bg8" <?php echo (sh_set($meta_settings['sh_page_options'][0], 'header_image' )) ? 'style="background-image:url('.sh_set($meta_settings['sh_page_options'][0], 'header_image' ).');"' : '';?>></div> 
		<div class="container">
			<div class="inner-head">
				<div class="inner-title">
					<h2><?php echo (sh_set($meta_settings['sh_page_options'][0], 'banner_title' )) ? sh_set($meta_settings['sh_page_options'][0], 'banner_title' ) : get_the_title(get_the_ID());?></h2>
					<span><?php echo sh_set($meta_settings['sh_page_options'][0], 'sub_title' );?></span>
				</div>
				<?php echo get_the_breadcrumb();?>
			</div>
		</div>
	</div>
</section>

<?php if(have_posts()): while(have_posts()): the_post(); ?>

    <section class="block">
        <div class="container">
            <div class="row">
                <div class="col-md-4">
                    <div class="profile-social bouncein">
                        <?php the_post_thumbnail('370x370');?>
                    <?php if ( sh_set($meta_settings['sh_page_options'][0], 'team_social' ) ): ?>
                        <ul>
                            <?php echo (sh_set($meta_settings['sh_page_options'][0], 'facebook' )) ? '<li><a href="'.sh_set($meta_settings['sh_page_options'][0], 'facebook' ).'" title="'.__('Facebook', 'wp_dastak').'"><i class="fa fa-facebook"></i></a></li>' : '';?>
                            <?php echo (sh_set($meta_settings['sh_page_options'][0], 'gplus' )) ? '<li><a href="'.sh_set($meta_settings['sh_page_options'][0], 'gplus' ).'" title="'.__('Google Plus', 'wp_dastak').'"><i class="fa fa-google-plus"></i></a></li>' : '';?>
                            <?php echo (sh_set($meta_settings['sh_page_options'][0], 'twitter' )) ? '<li><a href="'.sh_set($meta_settings['sh_page_options'][0], 'twitter' ).'" title="'.__('Twitter', 'wp_dastak').'"><i class="fa fa-twitter"></i></a></li>' : '';?>
                            <?php echo (sh_set($meta_settings['sh_page_options'][0], 'in' )) ? '<li><a href="'.sh_set($meta_settings['sh_page_options'][0], 'in' ).'" title="'.__('LinkedIn', 'wp_dastak').'"><i class="fa fa-linkedin"></i></a></li>' : '';?>
                        </ul>
                    <?php endif; ?>
                    </div>
                </div>
                <div class="col-md-8">
                    <div id="my-profile-info">
                        <h3><?php the_title();?></h3>
                        <span><?php echo sh_set($meta_settings['sh_page_options'][0], 'designation' );?></span>
                        <?php the_content();?>
                    </div><!-- Profile info -->
                </div>
            </div>
        </div>
    </section>
    
	<?php if($team_skills):?>
        <section class="block remove-gap">
            <div class="container">
                <div class="heading3">
                    <h2><i><?php _e('My', 'wp_dastak')?></i> <?php _e('Skills', 'wp_dastak')?></h2>
                </div>
                <div class="my-skills">
                <?php foreach($team_skills as $skill):?>
                    <div class="custom-progress">
                        <p><i><?php echo sh_set($skill, 'skill');?></i><?php echo sh_set($skill, 'description');?></p>
                        <div class="progress">
                          <div style="width: <?php echo sh_set($skill, 'skill_percent');?>%;" aria-valuemax="100" aria-valuemin="0" aria-valuenow="<?php echo sh_set($skill, 'skill_percent');?>" role="progressbar" class="progress-bar slideinleft">
                            <span><?php echo sh_set($skill, 'skill_percent');?>%</span>
                          </div>
                        </div>
                    </div><!-- Progress Bar 1 -->
                <?php endforeach;?>
                    
                </div>
            </div>
        </section>
    <?php endif;?>
    <?php if($tema_eperiences):?>
        <section class="block remove-gap">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <div class="heading3">
                        <h2><i><?php _e('My', 'wp_dastak')?></i> <?php _e('Experience', 'wp_dastak')?></h2>
                         
                    </div>
                    <div id="experience">
                        <ul>
                        	<?php $i = 1;?>
                            <?php $count = count($tema_eperiences);?>
                        	<?php foreach($tema_eperiences as $experience):?>
                                <li>
                                <span><?php echo sh_set($experience, 'year');?></span>
                                <h3><?php echo sh_set($experience, 'title');?></h3>
                                <i><?php echo sh_set($experience, 'designation');?></i>
                                <p><?php echo sh_set($experience, 'description');?></p>
                                </li>
                                <?php if($i%2 == 0 && $i < $count):?>
                                    </ul><ul>
                                <?php endif;?>
                               <?php $i++;?>
                            <?php endforeach;?>
                        </ul>
                    </div>
                </div><!-- Experience -->
                
                
            </div>
        </div>
    </section>
	<?php endif;?>
    
<?php endwhile;
endif;?>
<script type="text/javascript">
	jQuery(document).ready(function($) {
	
		$("#experience").owlCarousel({
			autoPlay :true,
			stopOnHover : true,
			goToFirstSpeed : 2000,
			slideSpeed:1500,
			items:2,
			singleItem : true,
			autoHeight : true,
			transitionStyle:"backSlide",
			navigation:true,
			pagination: false
		});	
		
	});
</script>

<?php get_footer();?>