<?php get_header();?>
<?php 
	$meta_settings  = get_post_meta($post->ID, 'sh_event_meta', true);
	$layout = sh_set($meta_settings, 'layout');
	$sidebar = sh_set($meta_settings, 'sidebar');
?>

<section class="block inner-head-sec">
	<div class="dark">
		<div class="fixed-img sec-bg8" <?php echo (sh_set($meta_settings, 'header_image' )) ? 'style="background-image:url('.sh_set($meta_settings, 'header_image').');"' : '';?>></div> 
		<div class="container">
			<div class="inner-head">
				<div class="inner-title">
					<h2><?php echo (sh_get_meta_value(get_the_ID(), 'banner_title')) ? sh_get_meta_value(get_the_ID(), 'sub_title') : get_the_title(get_the_ID());?></h2>
					<span><?php echo sh_get_meta_value(get_the_ID(), 'sub_title'); ?></span>
				</div>
				<?php echo get_the_breadcrumb();?>
			</div>
		</div>
	</div>
</section>
<?php wp_enqueue_script('jquery-downCount');?>
<section class="block">
	<div class="container">
		<div class="row">
        	
        	<?php if($sidebar && $layout == 'left'):?>
            	<aside class="col-md-3 slideinright">
                	<?php dynamic_sidebar( $sidebar ); ?>
                </aside>
            <?php endif;?>
            
			<div class="<?php echo ($layout == 'full' || $layout == '') ? 'col-md-12' : 'col-md-9';?>">
            	<?php if(have_posts()): while(have_posts()): the_post(); ?>
				<div class="inner-left">
					<div class="event-single">
						<div class="event-single-img">
							<?php the_post_thumbnail('870x347');?>
							<div class="event-count bouncein">
								<ul class="countdown">
									<li> <span class="days">00</span>
									<p class="days_ref"><?php _e('Days', 'wp_dastak')?></p>
									</li>
									<li> <span class="hours">00</span>
									<p class="hours_ref"><?php _e('Hour', 'wp_dastak')?></p>
									</li>
									<li> <span class="minutes">00</span>
									<p class="minutes_ref"><?php _e('Min', 'wp_dastak')?></p>
									</li>
									<li> <span class="seconds">00</span>
									<p class="seconds_ref"><?php _e('Sec', 'wp_dastak')?></p>
									</li>
								</ul>
							</div>
                             <script class="source" type="text/javascript">
								jQuery(document).ready(function($) {
									$('.countdown').downCount({
										date: '<?php echo date('m/d/Y', strtotime(sh_set($meta_settings, 'start_date')));?> <?php echo date('h:i:s', strtotime(sh_set($meta_settings, 'start_time')));?>',
										offset: +10
									}, function () {
										//alert('WOOT WOOT, done!');
									});
								});
							</script>
						</div>
						<h2><?php the_title();?></h2>
						<ul>
							<li><i class="fa fa-user"></i><?php the_author_meta( 'display_name' ); ?> </li>
							<li><i class="fa fa-calendar-o"></i><?php  echo date(get_option('date_format', sh_set($meta_settings, 'start_date')))?></li>
						</ul>
						<ul>
							<li><i class="fa fa-map-marker"></i><?php echo sh_set($meta_settings, 'location');?></li>
							<li><i class="fa fa-clock-o"></i><?php echo date('h:ia', strtotime(sh_set($meta_settings, 'start_time')))?> <?php _e('to', 'wp_dastak');?> <?php echo date('h:ia', strtotime(sh_set($meta_settings, 'end_time')));?> </li>
						</ul>
						
						<?php the_content();?>
						
						<?php if(get_the_tag_list()):?>
                            <ul class="meta-tags">
                                <li><i class="fa fa-tags"></i></li>
                                <?php echo get_the_tag_list('<li>','</li><li>','</li>');?>
                            </ul>
                        <?php endif;?>
					
						<?php if(sh_set($meta_settings, 'social_icons')):?>
							<?php sh_post_social_icons();?>
                        <?php endif;?>
									
					</div>
				</div><!-- Inner left Sec  -->
                    <!-- Project -->
				<?php endwhile;
                endif;?>
			</div>
			
			 <?php if($sidebar && $layout == 'right'):?>
            	<aside class="col-md-3 slideinright">
                	<?php dynamic_sidebar( $sidebar ); ?>
                </aside>
            <?php endif;?>
		</div>
	</div>
</section>

<?php get_footer();?>