<?php
$options = array();
$options[] =  array(
	'id'          => 'sh_post_meta',
	'types'       => array('post'),
	'title'       => __('Post Settings', 'wp_dastak'),
	'priority'    => 'high',
	'template'    => 
			array(
					array(
						'type'      => 'group',
						'repeating' => false,
						'length'    => 1,
						'name'      => 'sh_post_options',
						'title'     => __('General Post Settings', 'wp_dastak'),
						'fields'    => 
						array(
                                                        array(
                                                            'type' => 'toggle',
                                                            'name' => 'post_banner_section',
                                                            'label' => __('Show Banner Section', 'wp_dastak'),
                                                            'description' => __('Choose to show banner section', 'wp_dastak'),
                                                            'default' => 1,
                                                        ),
							array(
								'type' => 'textbox',
								'name' => 'banner_title',
								'label' => __('Banner Title', 'wp_dastak'),
								'default' => '',
                                                                'dependency' => array(
                                                                    'field' => 'post_banner_section',
                                                                    'function' => 'vp_dep_boolean',
								),
							),
							array(
								'type' => 'textbox',
								'name' => 'sub_title',
								'label' => __('Subtitle', 'wp_dastak'),
								'default' => '',
                                                                'dependency' => array(
                                                                    'field' => 'post_banner_section',
                                                                    'function' => 'vp_dep_boolean',
                                                                ),
							),
							array(
								'type' => 'upload',
								'name' => 'header_image',
								'label' => __('Header Image', 'wp_dastak'),
								'default' => '',
								'description' => __('Insert header image for this post', 'wp_dastak'),
                                                                'dependency' => array(
									'field' => 'post_banner_section',
									'function' => 'vp_dep_boolean',
								),
							),

							array(
								'type' => 'select',
								'name' => 'sidebar',
								'label' => __('Sidebar', 'wp_dastak'),
								'default' => '',
								'items' => sh_get_sidebars(true)	
							),
							
							array(
								'type' => 'radioimage',
								'name' => 'layout',
								'label' => __('Page Layout', 'wp_dastak'),
								'description' => __('Choose the layout for product', 'wp_dastak'),
								'items' => array(
									array(
										'value' => 'left',
										'label' => __('Left Sidebar', 'wp_dastak'),
										'img' => get_template_directory_uri().'/includes/vafpress/public/img/2cl.png',
									),
									array(
										'value' => 'right',
										'label' => __('Right Sidebar', 'wp_dastak'),
										'img' => get_template_directory_uri().'/includes/vafpress/public/img/2cr.png',
									),
									array(
										'value' => 'full',
										'label' => __('Full Width', 'wp_dastak'),
										'img' => get_template_directory_uri().'/includes/vafpress/public/img/1col.png',
									),
									
								),
							),
						
							array(
								'type' => 'textarea',
								'name' => 'video',
								'label' => __('Video Embed Code', 'wp_dastak'),
								'default' => '',
								'description' => __('If post format is video then this embed code will be used in content', 'wp_dastak')
							),
							array(
								'type' => 'textarea',
								'name' => 'audio',
								'label' => __('Audio Embed Code', 'wp_dastak'),
								'default' => '',
								'description' => __('If post format is AUDIO then this embed code will be used in content', 'wp_dastak')
							),
							array(
								'type' => 'toggle',
								'name' => 'user_meta',
								'label' => __('Show User Meta', 'wp_dastak'),
								'default' => '',
								'description' => __('Choose to show user meta', 'wp_dastak')
							),
							array(
								'type' => 'toggle',
								'name' => 'social_icons',
								'label' => __('Show Social Icons', 'wp_dastak'),
								'default' => '',
								'description' => __('Choose to show social icons', 'wp_dastak')
							),
							array(
								'type' => 'toggle',
								'name' => 'post_breadcrumb',
								'label' => __('Show BreadCrumb', 'wp_dastak'),
								'default' => '',
								'description' => __('Choose to show breadcrumb', 'wp_dastak'),
                                                                'dependency' => array(
									'field' => 'post_banner_section',
									'function' => 'vp_dep_boolean',
								),
							),
							array(
								'type' => 'toggle',
								'name' => 'related_posts',
								'label' => __('Show Related Posts', 'wp_dastak'),
								'default' => '',
							),
							
						),
					),
				),
);

/* Page options */
$options[] =  array(
	'id'          => 'sh_page_meta',
	'types'       => array('page'),
	'title'       => __('Page Settings', 'wp_dastak'),
	'priority'    => 'high',
	'template'    => 
			array(
					array(
						'type'      => 'group',
						'repeating' => false,
						'length'    => 1,
						'name'      => 'sh_post_options',
						'title'     => __('General Post Settings', 'wp_dastak'),
						'fields'    => 
						array(
                                                         array(
                                                            'type' => 'toggle',
                                                            'name' => 'page_banner_section',
                                                            'label' => __('Show Banner Section', 'wp_dastak'),
                                                            'description' => __('Choose to show banner section', 'wp_dastak'),
                                                            'default' => 1,
                                                        ),
							array(
								'type' => 'textbox',
								'name' => 'banner_title',
								'label' => __('Banner Title', 'wp_dastak'),
								'default' => '',
                                                                'dependency' => array(
                                                                    'field' => 'page_banner_section',
                                                                    'function' => 'vp_dep_boolean',
								),
							),
							array(
								'type' => 'textbox',
								'name' => 'sub_title',
								'label' => __('Subtitle', 'wp_dastak'),
								'default' => '',
                                                                'dependency' => array(
                                                                    'field' => 'page_banner_section',
                                                                    'function' => 'vp_dep_boolean',
								),
							),
							array(
								'type' => 'textbox',
								'name' => 'title_tag',
								'label' => __('Tag Title', 'wp_dastak'),
								'default' => '',
                                                                'dependency' => array(
                                                                    'field' => 'page_banner_section',
                                                                    'function' => 'vp_dep_boolean',
								),
							),
							array(
								'type' => 'upload',
								'name' => 'header_image',
								'label' => __('Header Image', 'wp_dastak'),
								'default' => '',
								'description' => __('Insert header image for this page', 'wp_dastak'),
                                                                'dependency' => array(
                                                                    'field' => 'page_banner_section',
                                                                    'function' => 'vp_dep_boolean',
								),
							),
							array(
								'type' => 'radioimage',
								'name' => 'layout',
								'label' => __('Page Layout', 'wp_dastak'),
								'description' => __('Choose the layout for page', 'wp_dastak'),
								'items' => array(
									array(
										'value' => 'left',
										'label' => __('Left Sidebar', 'wp_dastak'),
										'img' => get_template_directory_uri().'/includes/vafpress/public/img/2cl.png',
									),
									array(
										'value' => 'right',
										'label' => __('Right Sidebar', 'wp_dastak'),
										'img' => get_template_directory_uri().'/includes/vafpress/public/img/2cr.png',
									),
									array(
										'value' => 'full',
										'label' => __('Full Width', 'wp_dastak'),
										'img' => get_template_directory_uri().'/includes/vafpress/public/img/1col.png',
									),
									
								),
							),
							array(
								'type' => 'select',
								'name' => 'sidebar',
								'label' => __('Sidebar', 'wp_dastak'),
								'default' => '',
								'items' => sh_get_sidebars(true)	
							),
							array(
								'type' => 'toggle',
								'name' => 'is_home',
								'label' => __('Homepage ?', 'wp_dastak'),
								'default' => '',
								'description' => __('Choose whether its homepage or not', 'wp_dastak')
							),
							array(
								'type' => 'toggle',
								'name' => 'title',
								'label' => __('Show Title', 'wp_dastak'),
								'default' => '',
								'description' => __('Choose whether to show page title or not', 'wp_dastak')
							),
							array(
								'type' => 'toggle',
								'name' => 'breadcrumb',
								'label' => __('Show BreadCrumb', 'wp_dastak'),
								'default' => '',
								'description' => __('Choose whether to show page breadcrumb or not', 'wp_dastak'),
                                                                'dependency' => array(
									'field' => 'page_banner_section',
									'function' => 'vp_dep_boolean',
								),
							),
												
							array(
								'type' => 'select',
								'name' => 'page_title_style',
								'label' => __('Page Title Style', 'wp_dastak'),
								'description' => __('Select page title style', 'wp_dastak'),
								'dependency' => array(
									'field' => 'title',
									'function' => 'vp_dep_boolean',
								),
								'default' => '',
								'items' => array(array('value' => '1', 'label' => 'Title Style One'),array('value' => '2', 'label' => 'Title Style Two'),array('value' => '3', 'label' => 'Title Style Three'),array('value' => '4', 'label' => 'Title Style Four'),array('value' => '5', 'label' => 'Title Style Five'))	
							),
								
							
						),
					),
				),
);

/** Portfolio Options */
$options[] =  array(
	'id'          => 'sh_portfolio_meta',
	'types'       => array('sh_portfolio'),
	'title'       => __('Portfolio Options', 'wp_dastak'),
	'priority'    => 'high',
	'template'    => array(
		array(
			'type'      => 'group',
			'repeating' => false,
			'length'    => 1,
			'name'      => 'sh_page_options',
			'title'     => __('Portfolio Information', 'wp_dastak'),
			'fields'    => array(
				array(
					'type' => 'textbox',
					'name' => 'banner_title',
					'label' => __('Banner Title', 'wp_dastak'),
					'default' => '',
				),
				array(
					'type' => 'textbox',
					'name' => 'subtitle',
					'label' => __('Sub Title', 'wp_dastak'),
					'default' => '',
				),
				array(
					'type' => 'upload',
					'name' => 'header_image',
					'label' => __('Header Image', 'wp_dastak'),
					'default' => '',
					'description' => __('Header image for project detail page', 'wp_dastak'),
				),
				array(
					'type' => 'radioimage',
					'name' => 'layout',
					'label' => __('Layout', 'wp_dastak'),
					'description' => __('Choose the layout project detail page', 'wp_dastak'),
					'items' => array(
						array(
							'value' => 'left',
							'label' => __('Left Sidebar', 'wp_dastak'),
							'img' => get_template_directory_uri().'/includes/vafpress/public/img/2cl.png',
						),
						array(
							'value' => 'right',
							'label' => __('Right Sidebar', 'wp_dastak'),
							'img' => get_template_directory_uri().'/includes/vafpress/public/img/2cr.png',
						),
						array(
							'value' => 'full',
							'label' => __('Full Width', 'wp_dastak'),
							'img' => get_template_directory_uri().'/includes/vafpress/public/img/1col.png',
						),
						
					),
				),
				array(
					'type' => 'select',
					'name' => 'sidebar',
					'label' => __('Sidebar', 'wp_dastak'),
					'default' => '',
					'items' => sh_get_sidebars(true)
				),
				array(
					'type' => 'textbox',
					'name' => 'author',
					'label' => __('Author', 'wp_dastak'),
					'default' => 'Derek Andorson',
				),
				array(
					'type' => 'toggle',
					'name' => 'show_icon',
					'label' => __('Show Icon', 'wp_dastak'),
					'default' => '',
				),
				array(
					'type' => 'fontawesome',
					'name' => 'fontawesome',
					'label' => __('Icon', 'wp_dastak'),
					'default' => '',
					'dependency' => array(
						'field'    => 'show_icon',
						'function' => 'vp_dep_boolean',
					),
				),
				array(
					'type' => 'toggle',
					'name' => 'related_portfolio',
					'label' => __('Show Related Portfolios', 'wp_dastak'),
					'default' => '',
				),
			),
		),
	),
);


/** Project Options */
$options[] =  array(
	'id'          => 'sh_project_option',
	'types'       => array('sh_project'),
	'title'       => __('Project Options', 'wp_dastak'),
	'priority'    => 'high',
	'template'    => array(
				array(
					'type' => 'textbox',
					'name' => 'banner_title',
					'label' => __('Banner Title', 'wp_dastak'),
					'default' => '',
				),
				array(
					'type' => 'textbox',
					'name' => 'subtitle',
					'label' => __('Sub Title', 'wp_dastak'),
					'default' => '',
				),
				array(
					'type' => 'upload',
					'name' => 'header_image',
					'label' => __('Header Image', 'wp_dastak'),
					'default' => '',
					'description' => __('Header image for project detail page', 'wp_dastak'),
				),
				array(
					'type' => 'radioimage',
					'name' => 'layout',
					'label' => __('Layout', 'wp_dastak'),
					'description' => __('Choose the layout project detail page', 'wp_dastak'),
					'items' => array(
						array(
							'value' => 'left',
							'label' => __('Left Sidebar', 'wp_dastak'),
							'img' => get_template_directory_uri().'/includes/vafpress/public/img/2cl.png',
						),
						array(
							'value' => 'right',
							'label' => __('Right Sidebar', 'wp_dastak'),
							'img' => get_template_directory_uri().'/includes/vafpress/public/img/2cr.png',
						),
						array(
							'value' => 'full',
							'label' => __('Full Width', 'wp_dastak'),
							'img' => get_template_directory_uri().'/includes/vafpress/public/img/1col.png',
						),
						
					),
				),
				array(
					'type' => 'select',
					'name' => 'sidebar',
					'label' => __('Sidebar', 'wp_dastak'),
					'default' => '',
					'items' => sh_get_sidebars(true)
				),
				array(
					'type' => 'date',
					'name' => 'launched_date',
					'label' => __('Launched Date', 'wp_dastak'),
					'default' => '',
				),
				array(
					'type' => 'date',
					'name' => 'funding_end_date',
					'label' => __('Funding End Date', 'wp_dastak'),
					'default' => '',
				),
				array(
					'type' => 'time',
					'name' => 'funding_end_time',
					'label' => __('Funding End Time', 'wp_dastak'),
					'default' => '',
				),
				array(
					'type' => 'textbox',
					'name' => 'goal',
					'label' => __('Our Goal', 'wp_dastak'),
					'default' => '',
				),
				array(
					'type' => 'textbox',
					'name' => 'author',
					'label' => __('Author', 'wp_dastak'),
					'default' => 'Derek Andorson',
				),
				array(
					'type' => 'upload',
					'name' => 'author_image',
					'label' => __('Author Image', 'wp_dastak'),
					'default' => '',
					'description' => __('Authoer image for project', 'wp_dastak'),
				),
				/*array(
					'type' => 'toggle',
					'name' => 'faqs',
					'label' => __('Show Faqs', 'wp_dastak'),
					'default' => '',
				),
				array(
					'type' => 'select',
					'name' => 'category',
					'labe' => __('Select Category', 'wp_dastak'),
					'items' => sh_get_categories(array('taxonomy'=>'faq_category','hide_empty' => 0), false, true),
				),*/
				array(
					'type' => 'toggle',
					'name' => 'related_projects',
					'label' => __('Show Related Projects', 'wp_dastak'),
					'default' => '',
				),
	),
);


/** Case Study Options */
$options[] =  array(
	'id'          => 'sh_case_studies_option',
	'types'       => array('sh_case_studies'),
	'title'       => __('Case Study Options', 'wp_dastak'),
	'priority'    => 'high',
	'template'    => array(
				
				array(
					'type' => 'select',
					'name' => 'sidebar',
					'label' => __('Sidebar', 'wp_dastak'),
					'default' => '',
					'items' => sh_get_sidebars(true)
				),
				
				array(
					'type' => 'fontawesome',
					'name' => 'fontawesome',
					'label' => __('Case Study Icon', 'wp_dastak'),
					'default' => '',
				),
				
				array(
					'type' => 'toggle',
					'name' => 'download',
					'label' => __('Show Download Button', 'wp_dastak'),
					'default' => '',
				),
				array(
					'type' => 'upload',
					'name' => 'case_study_pdf',
					'label' => __('Upload PDF', 'wp_dastak'),
					'default' => '',
					'description' => __('Upload PDF for case study', 'wp_dastak'),
				),
				array(
					'type' => 'textbox',
					'name' => 'label',
					'label' => __('Button Label', 'wp_dastak'),
					'default' => '',
				),

	),
);


/** Team Options*/
$options[] =  array(
	'id'          => 'sh_team_meta',
	'types'       => array('sh_team'),
	'title'       => __('Team Options', 'wp_dastak'),
	'priority'    => 'high',
	'template'    => array(
		
		array(
			'type'      => 'group',
			'repeating' => false,
			'length'    => 1,
			'name'      => 'sh_page_options',
			'title'     => __('Team Member Information', 'wp_dastak'),
			'fields'    => array(
				array(
					'type' => 'textbox',
					'name' => 'banner_title',
					'label' => __('Banner Title', 'wp_dastak'),
					'default' => '',
				),
				array(
					'type' => 'textbox',
					'name' => 'sub_title',
					'label' => __('Subtitle', 'wp_dastak'),
					'default' => '',
				),
			
				array(
					'type' => 'upload',
					'name' => 'header_image',
					'label' => __('Header Image', 'wp_dastak'),
					'default' => '',
					'description' => __('Insert header image for this post', 'wp_dastak'),
				),
				
				array(
					'type' => 'textbox',
					'name' => 'designation',
					'label' => __('Designation', 'wp_dastak'),
					'default' => '',
				),
				array(
					'type' => 'textbox',
					'name' => 'site_label',
					'label' => __('Site Label', 'wp_dastak'),
					'default' => '',
				),
				array(
					'type' => 'textbox',
					'name' => 'site_url',
					'label' => __('Site URL', 'wp_dastak'),
					'default' => '',
				),
                                array(
                                    'type' => 'toggle',
                                    'name' => 'team_social',
                                    'label' => __('Show Socail Icons', 'wp_dastak'),
                                    'description' => __('Enable to Show socail icons on team featured image.', 'wp_dastak'),
                                    'default' => 1,
                                ),
				array(
					'type' => 'textbox',
					'name' => 'facebook',
					'label' => __('Facebook', 'wp_dastak'),
					'default' => '',
					'dependency' => array(
                                                'field' => 'team_social',
                                                'function' => 'vp_dep_boolean',
                                        ),
				),
				array(
					'type' => 'textbox',
					'name' => 'twitter',
					'label' => __('Twitter', 'wp_dastak'),
					'default' => '',
                                        'dependency' => array(
                                                'field' => 'team_social',
                                                'function' => 'vp_dep_boolean',
                                        ),
				),
				array(
					'type' => 'textbox',
					'name' => 'in',
					'label' => __('LinkedIn', 'wp_dastak'),
					'default' => '',
                                        'dependency' => array(
                                                'field' => 'team_social',
                                                'function' => 'vp_dep_boolean',
                                        ),
				),
				array(
					'type' => 'textbox',
					'name' => 'gplus',
					'label' => __('GPlus', 'wp_dastak'),
                                        'dependency' => array(
                                                'field' => 'team_social',
                                                'function' => 'vp_dep_boolean',
                                        ),
				),
				array(
					'type' => 'textbox',
					'name' => 'email',
					'label' => __('Email', 'wp_dastak'),
				),
				
				
			),
		),
					
		array(
			'type' => 'group',
			'repeating' => true,
			'sortable'  => true,
			'length'    => 1,
			'name'      => 'sh_team_skills_options',
			'title'     => __('Skills Information', 'wp_dastak'),
			'fields' => array(
		
				array(
					'type' => 'textbox',
					'name' => 'skill',
					'label' => __('Skill Name', 'wp_dastak'),
					'default' => '',
				),
				array(
					'type' => 'textarea',
					'name' => 'description',
					'label' => __('Description', 'wp_dastak'),
					'default' => '',
				),
				array(
					'type' => 'slider',
					'name' => 'skill_percent',
					'label' => __('Skill Percentage', 'wp_dastak'),
					'min' => '1',
					'max' => '100',
					'step' => '1',
					'default' => '50',
					
				),
				
			),
		),
		
		array(
			'type' => 'group',
			'repeating' => true,
			'sortable'  => true,
			'length'    => 1,
			'name'      => 'sh_team_experience_options',
			'title'     => __('Team Experience Information', 'wp_dastak'),
			'fields' => array(
		
				array(
					'type' => 'textbox',
					'name' => 'title',
					'label' => __('Title', 'wp_dastak'),
					'default' => '',
				),
				array(
					'type' => 'textbox',
					'name' => 'designation',
					'label' => __('Designation', 'wp_dastak'),
					'default' => '',
				),
				array(
					'type' => 'textarea',
					'name' => 'description',
					'label' => __('Description', 'wp_dastak'),
					'default' => '',
					
				),
				array(
					'type' => 'textbox',
					'name' => 'year',
					'label' => __('Year', 'wp_dastak'),
					'default' => '',
				),
				
			),
		),
		
					
	),
);

/** Gallery Options*/
$options[] =  array(
	'id'          => 'sh_gallery_meta',
	'types'       => array('sh_gallery'),
	'title'       => __('Gallery Options', 'wp_dastak'),
	'priority'    => 'high',
	'template'    => array(
		
		array(
			'type'      => 'group',
			'repeating' => false,
			'length'    => 1,
			'name'      => 'sh_page_options',
			'title'     => __('Team Member Information', 'wp_dastak'),
			'fields'    => array(
				array(
					'type' => 'textbox',
					'name' => 'banner_title',
					'label' => __('Banner Title', 'wp_dastak'),
					'default' => '',
				),
				array(
					'type' => 'textbox',
					'name' => 'sub_title',
					'label' => __('Subtitle', 'wp_dastak'),
					'default' => '',
				),
			
				array(
					'type' => 'upload',
					'name' => 'header_image',
					'label' => __('Header Image', 'wp_dastak'),
					'default' => '',
					'description' => __('Insert header image for this post', 'wp_dastak'),
				),
				array(
					'type' => 'radioimage',
					'name' => 'layout',
					'label' => __('Gallery Page Layout', 'wp_dastak'),
					'description' => __('Choose the layout for gallery', 'wp_dastak'),
					'items' => array(
						array(
							'value' => 'left',
							'label' => __('Left Sidebar', 'wp_dastak'),
							'img' => get_template_directory_uri().'/includes/vafpress/public/img/2cl.png',
						),
						array(
							'value' => 'right',
							'label' => __('Right Sidebar', 'wp_dastak'),
							'img' => get_template_directory_uri().'/includes/vafpress/public/img/2cr.png',
						),
						array(
							'value' => 'full',
							'label' => __('Full Width', 'wp_dastak'),
							'img' => get_template_directory_uri().'/includes/vafpress/public/img/1col.png',
						),
						
					),
				),
				array(
					'type' => 'select',
					'name' => 'sidebar',
					'label' => __('Sidebar', 'wp_dastak'),
					'default' => '',
					'items' => sh_get_sidebars(true)	
				),
				array(
					'type' => 'select',
					'name' => 'cols',
					'label' => __('Number of Columns', 'wp_dastak'),
					'default' => '',
					'items' => array(
								array('value'=>'12', 'label' => 'One Column' ),
								array('value'=>'4', 'label' => 'Three Columns' ),
								array('value'=>'3', 'label' => 'Four Columns' )
					),		
				),
				
			),
		),
					
		array(
			'type' => 'group',
			'repeating' => true,
			'sortable'  => true,
			'length'    => 1,
			'name'      => 'sh_team_images_options',
			'title'     => __('Gallery Images', 'wp_dastak'),
			'fields' => array(
		
				array(
					'type' => 'textbox',
					'name' => 'title',
					'label' => __('Title', 'wp_dastak'),
					'default' => '',
				),
				array(
					'type' => 'upload',
					'name' => 'image',
					'label' => __('Image', 'wp_dastak'),
					'default' => '',
					'description' => __('Insert gallery image for this gallery', 'wp_dastak'),
				),
			),
		),
					
	),
);




/** Testimonial Options*/
$options[] =  array(
	'id'          => 'sh_testimonial_options',
	'types'       => array('sh_testimonial'),
	'title'       => __('Testimonials Options', 'wp_dastak'),
	'priority'    => 'high',
	'template'    => array(
				array(
					'type' => 'textbox',
					'name' => 'designation',
					'label' => __('Designation', 'wp_dastak'),
					'default' => '',
				),
				array(
					'type' => 'textbox',
					'name' => 'link',
					'label' => __('URL', 'wp_dastak'),
					'default' => 'http://example.com',
				)
	),
);



/** Partner Options Options*/
$options[] =  array(
	'id'          => 'sh_partner_meta',
	'types'       => array('sh_partner'),
	'title'       => __('Partner Options', 'wp_dastak'),
	'priority'    => 'high',
	'template'    => array(
						
			array(
				'type' => 'textbox',
				'name' => 'link',
				'label' => __('Partner URL', 'wp_dastak'),
				'default' => '',
			),
	),
);

/** Events Options Options*/
$options[] =  array(
	'id'          => 'sh_event_meta',
	'types'       => array('sh_event'),
	'title'       => __('Event Options', 'wp_dastak'),
	'priority'    => 'high',
	'template'    => array(
			array(
				'type' => 'textbox',
				'name' => 'banner_title',
				'label' => __('Banner Title', 'wp_dastak'),
				'default' => '',
			),
			array(
				'type' => 'textbox',
				'name' => 'sub_title',
				'label' => __('Subtitle', 'wp_dastak'),
				'default' => '',
			),
		
			array(
				'type' => 'upload',
				'name' => 'header_image',
				'label' => __('Header Image', 'wp_dastak'),
				'default' => '',
				'description' => __('Insert header image for this post', 'wp_dastak'),
			),
			
			array(
				'type' => 'radioimage',
				'name' => 'layout',
				'label' => __('Layout', 'wp_dastak'),
				'description' => __('Choose the layout project detail page', 'wp_dastak'),
				'items' => array(
					array(
						'value' => 'left',
						'label' => __('Left Sidebar', 'wp_dastak'),
						'img' => get_template_directory_uri().'/includes/vafpress/public/img/2cl.png',
					),
					array(
						'value' => 'right',
						'label' => __('Right Sidebar', 'wp_dastak'),
						'img' => get_template_directory_uri().'/includes/vafpress/public/img/2cr.png',
					),
					array(
						'value' => 'full',
						'label' => __('Full Width', 'wp_dastak'),
						'img' => get_template_directory_uri().'/includes/vafpress/public/img/1col.png',
					),
					
				),
			),
			array(
				'type' => 'select',
				'name' => 'sidebar',
				'label' => __('Sidebar', 'wp_dastak'),
				'default' => '',
				'items' => sh_get_sidebars(true)
			),
						
			array(
				'type' => 'date',
				'name' => 'start_date',
				'label' => __('Start Date', 'wp_dastak'),
				'default' => '',
			),
			array(
				'type' => 'time',
				'name' => 'start_time',
				'label' => __('Start Time', 'wp_dastak'),
				'default' => '',
			),
			array(
				'type' => 'date',
				'name' => 'end_date',
				'label' => __('Event Date', 'wp_dastak'),
				'default' => '',
			),
			array(
				'type' => 'time',
				'name' => 'end_time',
				'label' => __('End Time', 'wp_dastak'),
				'default' => '',
			),
			array(
				'type' => 'textbox',
				'name' => 'location',
				'label' => __('Event Location', 'wp_dastak'),
				'default' => '',
			),
			array(
				'type' => 'textbox',
				'name' => 'organizer',
				'label' => __('Organizer', 'wp_dastak'),
				'default' => '',
			),
			array(
				'type' => 'textbox',
				'name' => 'organizer_address',
				'label' => __('Organizer Address', 'wp_dastak'),
				'default' => '',
			),
			array(
				'type' => 'toggle',
				'name' => 'social_icons',
				'label' => __('Show Social Icons', 'wp_dastak'),
				'default' => '',
				'description' => __('Choose to show social icons', 'wp_dastak')
			),
	),
);

$options[] =  array(
	'id'          => 'sh_services_option',
	'types'       => array( 'sh_service' ),
	'title'       => __('Post Settings', 'wp_dastak'),
	'priority'    => 'high',
	'template'    => 

			array(
				array(
					'type' => 'textbox',
					'name' => 'banner_title',
					'label' => __('Banner Title', 'wp_dastak'),
					'default' => '',
				),
				array(
					'type' => 'textbox',
					'name' => 'sub_title',
					'label' => __('Sub Title', 'wp_dastak'),
					'default' => '',
				),
			
				array(
					'type' => 'upload',
					'name' => 'header_image',
					'label' => __('Header Image', 'wp_dastak'),
					'default' => '',
					'description' => __('Insert header image for this service', 'wp_dastak'),
				),
				
				array(
					'type' => 'fontawesome',
					'name' => 'fontawesome',
					'label' => __('Service Icon', 'wp_dastak'),
					'default' => '',
				),
				array(
					'type' => 'toggle',
					'name' => 'related_services',
					'label' => __('Show Related Services', 'wp_dastak'),
					'default' => '',
					'description' => __('Choose to show related services', 'wp_dastak')
				),
				array(
					'type'      => 'group',
					'repeating' => true,
					'sortable'  => true,
					'name'      => 'row',
					'title'     => __('Row', 'wp_dastak'),
					'fields'    => array(
						
						array(
							'type'  		=> 'textbox',
							'label'       => __('Skill Name', 'wp_dastak'),
							'name'        => 'skill_name',
							'validation'  => '',
						),

					),
					
				),
				
	),
);


$options[] =  array(
	'id'          => 'sh_jobs_option',
	'types'       => array( 'sh_jobs' ),
	'title'       => __('Job Settings', 'wp_dastak'),
	'priority'    => 'high',
	'template'    => 

			array(
				array(
					'type' => 'textbox',
					'name' => 'banner_title',
					'label' => __('Banner Title', 'wp_dastak'),
					'default' => '',
				),
				array(
					'type' => 'textbox',
					'name' => 'sub_title',
					'label' => __('Sub Title', 'wp_dastak'),
					'default' => '',
				),
			
				array(
					'type' => 'upload',
					'name' => 'header_image',
					'label' => __('Header Image', 'wp_dastak'),
					'default' => '',
					'description' => __('Insert header image for this job', 'wp_dastak'),
				),
			
				array(
					'type'  		=> 'textbox',
					'label'       => __('Job Shifts', 'wp_dastak'),
					'name'        => 'job_shifts',
					'validation'  => '',
				),
				
				array(
					'type'  		=> 'textbox',
					'label'       => __('Job Position', 'wp_dastak'),
					'name'        => 'job_position',
					'validation'  => '',
				),
				
				array(
					'type'  		=> 'textbox',
					'label'       => __('Experience Required', 'wp_dastak'),
					'name'        => 'experience',
					'validation'  => '',
				),
				
				array(
					'type'  		=> 'textbox',
					'label'       => __('Pay Start', 'wp_dastak'),
					'name'        => 'pay',
					'validation'  => '',
				),
			
				array(
					'type'  		=> 'textbox',
					'label'       => __('Job Location', 'wp_dastak'),
					'name'        => 'job_location',
					'validation'  => '',
				),
				
				array(
					'type'  		=> 'textarea',
					'label'       => __('Location Map', 'wp_dastak'),
					'name'        => 'location_map',
					'validation'  => '',
				),
				
				array(
					'type'      => 'group',
					'repeating' => true,
					'sortable'  => true,
					'name'      => 'row',
					'title'     => __('Row', 'vp_textdomain'),
					'fields'    => array(
						
						array(
							'type'  		=> 'textbox',
							'label'       => __('Skill Name', 'wp_dastak'),
							'name'        => 'skill_name',
							'validation'  => '',
						),
					),
					
				),
				
	),
);


$options[] =  array(
	'id'          => 'sh_history_option',
	'types'       => array( 'sh_history' ),
	'title'       => __('History Settings', 'wp_dastak'),
	'priority'    => 'high',
	'template'    => 

			array(
				array(
					'type' => 'textbox',
					'name' => 'banner_title',
					'label' => __('Banner Title', 'wp_dastak'),
					'default' => '',
				),
				array(
					'type' => 'textbox',
					'name' => 'sub_title',
					'label' => __('Sub Title', 'wp_dastak'),
					'default' => '',
				),
			
				array(
					'type' => 'upload',
					'name' => 'header_image',
					'label' => __('Header Image', 'wp_dastak'),
					'default' => '',
					'description' => __('Insert header image for this job', 'wp_dastak'),
				),
			
				array(
					'type'  		=> 'textbox',
					'label'       => __('History Title', 'wp_dastak'),
					'name'        => 'title',
					'validation'  => '',
				),
				array(
					'type' => 'fontawesome',
					'name' => 'icon',
					'label' => __('Icon', 'wp_dastak'),
					'default' => '',
					'description' => __('Choose icon that best represent the item feature', 'wp_dastak')
				),
				array(
						'type'  => 'textarea',
						'name'  => 'map',
						'label' => __('Map', 'wp_dastak'),
						'default' => '',
						'description' => __('Enter the iframe for the map of company', 'wp_dastak')
					),
			
				
				
	),
);

$options[] =  array(
	'id'          => 'sh_faq_option',
	'types'       => array( 'sh_faq' ),
	'title'       => __('FAQs Settings', 'wp_dastak'),
	'priority'    => 'high',
	'template'    => 

			array(
			
				array(
					'type' => 'textbox',
					'name' => 'author',
					'label' => __('Author', 'wp_dastak'),
					'default' => '',
				),
			
				array(
					'type' => 'textbox',
					'name' => 'designation',
					'label' => __('Designation', 'wp_dastak'),
					'default' => '',
				),
			
				
				
	),
);

/* Deal settings */
$options[] =  array(
	'id'          => 'sh_deal_option',
	'types'       => array( 'sh_deal' ),
	'title'       => __('Deal Settings', 'wp_dastak'),
	'priority'    => 'high',
	'template'    => 

			array(
				
				array(
				   'type' => 'textbox', //builtin fields include:
				   'name' => 'sub_title',
				   'label' => __('Sub Title', 'wp_dastak'),
				   'default' => '',
				),
				
				array(
				   'type' => 'textbox', //builtin fields include:
				   'name' => 'discount',
				   'label' => __('Discount', 'wp_dastak'),
				   'default' => '30%',
				),

				array(
				   'type' => 'select', //builtin fields include:
				   'name' => 'products',
				   'label' => __('Products', 'wp_dastak'),
				   'default' => '',
				   'items' => sh_get_posts_array2('product', true),
				),
				
			),
);

/* Page options */
$options[] =  array(
	'id'          => 'sh_product_meta',
	'types'       => array('product'),
	'title'       => __('Product Settings', 'wp_dastak'),
	'priority'    => 'high',
	'template'    => 
			array(
					array(
						'type'      => 'group',
						'repeating' => false,
						'length'    => 1,
						'name'      => 'sh_product_options',
						'title'     => __('General Product Settings', 'wp_dastak'),
						'fields'    => 
						array(
							
							array(
								'type' => 'radioimage',
								'name' => 'layout',
								'label' => __('Page Layout', 'wp_dastak'),
								'description' => __('Choose the layout for product', 'wp_dastak'),
								'items' => array(
									array(
										'value' => 'left',
										'label' => __('Left Sidebar', 'wp_dastak'),
										'img' => get_template_directory_uri().'/includes/vafpress/public/img/2cl.png',
									),
									array(
										'value' => 'right',
										'label' => __('Right Sidebar', 'wp_dastak'),
										'img' => get_template_directory_uri().'/includes/vafpress/public/img/2cr.png',
									),
									array(
										'value' => 'full',
										'label' => __('Full Width', 'wp_dastak'),
										'img' => get_template_directory_uri().'/includes/vafpress/public/img/1col.png',
									),
									
								),
							),

							array(
								'type' => 'select',
								'name' => 'sidebar',
								'label' => __('Sidebar', 'wp_dastak'),
								'default' => '',
								'items' => sh_get_sidebars(true)	
							),
						
						
						array(
								'type' => 'upload',
								'name' => 'header_image',
								'label' => __('Header Image', 'wp_dastak'),
								'default' => '',
								'description' => __('Upload Header Image.', 'wp_dastak')
							),
							
						array(
								'type' => 'textbox',
								'name' => 'sub_title',
								'label' => __('Sub Title', 'wp_dastak'),
								'default' => '',
						),
						array(
							'type' => 'textbox',
							'name' => 'banner_title',
							'label' => __('Banner Title', 'wp_dastak'),
							'default' => '',
						),
							
						),
						
						
					),
				),
);


$options[] =  array(
	'id'          => 'sh_form_settings',
	'types'       => array( 'sh_forms' ),
	'title'       => __('Form Settings', 'wp_dastak'),
	'priority'    => 'high',
	'template'    => 

			array(
					array(
						'type'  => 'radiobutton',
						'name'  => 'form_method',
						'label' => __('Form Submit Method', 'wp_dastak'),
						'items' => array(
							array('value' => 'post', 'label' => __('POST', 'wp_dastak') ),
							array('value' => 'get', 'label' => __('GET', 'wp_dastak') ),
						),
						'default' => 'text',
					),
					/*array(
						'type'  => 'toggle',
						'name'  => 'ajax',
						'label' => __('Ajax', 'wp_dastak'),
						'default' => '',
					),*/
					array(
						'type'  => 'textbox',
						'name'  => 'form_action',
						'label' => __('Form Action URL', 'wp_dastak'),
						'default' => 'text',
						'placeholder' => 'http://example.com'
					),
					array(
						'type'  => 'textbox',
						'name'  => 'form_email',
						'label' => __('Reciever Email', 'wp_dastak'),
						'default' => '',
						'description' => __('Enter the email address of receiver to send the form submission detail', 'wp_dastak')
					),
                                        array(
						'type'  => 'textbox',
						'name'  => 'form_subject',
						'label' => __('Subject Of Incoming Mail', 'wp_dastak'),
						'default' => '',
						'description' => __('Enter the subject of incoming mail.', 'wp_dastak')
					),
					array(
						'type'  => 'textarea',
						'name'  => 'form_success_msg',
						'label' => __('Success Message', 'wp_dastak'),
						'default' => '',
						'description' => __('Enter the message to show after successful submission of the form', 'wp_dastak')
					),
					array(
						'type'  => 'textbox',
						'name'  => 'button_label',
						'label' => __('Button Label', 'wp_dastak'),
						'default' => '',
						'description' => __('Enter the form submit button label', 'wp_dastak')
					),
					array(
						'type'  => 'textbox',
						'name'  => 'button_class',
						'label' => __('Button Class', 'wp_dastak'),
						'default' => '',
						'description' => __('Enter the form submit button class', 'wp_dastak')
					),
			)
);

$options[] =  array(
	'id'          => 'sh_forms_option',
	'types'       => array( 'sh_forms' ),
	'title'       => __('Form Builder', 'wp_dastak'),
	'priority'    => 'high',
	'template'    => 

			array(

				array(
					'type'      => 'group',
					'repeating' => true,
					'sortable'  => true,
					'name'      => 'field',
					'title'     => __('Field', 'wp_dastak'),
					'fields'    => array(
						
						array(
							'type'  => 'select',
							'name'  => 'type',
							'label' => __('Field Type', 'wp_dastak'),
							'items' => array(
								array('value' => 'text', 'label' => __('Text Input', 'wp_dastak') ),
								array('value' => 'password', 'label' => __('Password', 'wp_dastak') ),
								array('value' => 'email', 'label' => __('Email', 'wp_dastak') ),
								array('value' => 'range', 'label' => __('Range', 'wp_dastak') ),
								array('value' => 'url', 'label' => __('URL', 'wp_dastak') ),
								array('value' => 'select', 'label' => __('Dropdown', 'wp_dastak') ),
								array('value' => 'checkbox', 'label' => __('Checkbox', 'wp_dastak') ),
								array('value' => 'radio', 'label' => __('Radio Button', 'wp_dastak') ),
								array('value' => 'textarea', 'label' => __('Textarea', 'wp_dastak') ),
								array('value' => 'hiddentextbox', 'label' => __('Hidden Input', 'wp_dastak') ),
							),
							'default' => 'text',
						),
						array(
							'type'      => 'group',
							'repeating' => true,
							'sortable'  => true,
							'name'      => 'select_value',
							'title'     => __('Dropdown Values', 'wp_dastak'),
							'dependency' => array(
								'field'    => 'type',
								'function' => 'sh_dep_pb_dropdown',
							),
							'fields'    => array(
								
								array(
									'type'  => 'textbox',
									'name'  => 'dropdown_value',
									'label' => __('Value', 'wp_dastak'),
									'default' => 'option1',
								),
								array(
									'type'  => 'textbox',
									'name'  => 'dropdown_label',
									'label' => __('Label', 'wp_dastak'),
									'default' => 'Value1',
								),
							),
						),
						array(
							'type'      => 'group',
							'repeating' => true,
							'sortable'  => true,
							'name'      => 'checkbox_value',
							'title'     => __('Checkbox Values', 'wp_dastak'),
							'dependency' => array(
								'field'    => 'type',
								'function' => 'sh_dep_pb_checkbox',
							),
							'fields'    => array(
								
								array(
									'type'  => 'textbox',
									'name'  => 'check_value',
									'label' => __('Value', 'wp_dastak'),
									'default' => 'option1',
								),
								array(
									'type'  => 'textbox',
									'name'  => 'check_label',
									'label' => __('Label', 'wp_dastak'),
									'default' => 'Value1',
								),
							),
						),
						array(
							'type'      => 'group',
							'repeating' => true,
							'sortable'  => true,
							'name'      => 'radio_value',
							'title'     => __('Radio Values', 'wp_dastak'),
							'dependency' => array(
								'field'    => 'type',
								'function' => 'sh_dep_pb_radio',
							),
							'fields'    => array(
								
								array(
									'type'  => 'textbox',
									'name'  => 'radio_value',
									'label' => __('Value', 'wp_dastak'),
									'default' => 'option1',
								),
								array(
									'type'  => 'textbox',
									'name'  => 'radio_label',
									'label' => __('Label', 'wp_dastak'),
									'default' => 'Value1',
								),
							),
						),
						array(
							'type'  => 'checkbox',
							'name'  => 'validation',
							'label' => __('Validation', 'wp_dastak'),
							'items' => array(
								array('value' => 'required', 'label' => __('Required', 'wp_dastak') ),
								array('value' => 'alphabet', 'label' => __('Alphabetic', 'wp_dastak') ),
								array('value' => 'alphanumeric', 'label' => __('Alphanumeric', 'wp_dastak') ),
								array('value' => 'numeric', 'label' => __('Numeric', 'wp_dastak') ),
								array('value' => 'valid_email', 'label' => __('Email', 'wp_dastak') ),
								array('value' => 'url', 'label' => __('URL', 'wp_dastak') ),
							),
							'default' => 'text',
						),
						array(
							'type'  		=> 'textbox',
							'label'       => __('Field Name', 'wp_dastak'),
							'name'        => 'name',
							'validation'  => '',
						),
						array(
							'type'  		=> 'textbox',
							'label'       => __('Field Label', 'wp_dastak'),
							'name'        => 'label',
							'validation'  => '',
						),
						array(
								'type' => 'fontawesome',
								'name' => 'icon',
								'label' => __('Label Icon', 'wp_dastak'),
								'default' => ''
							),
						array(
							'type'  		=> 'textbox',
							'label'       => __('Default Value', 'wp_dastak'),
							'name'        => 'default',
							'validation'  => '',
						),
						array(
							'type'  		=> 'textbox',
							'label'       => __('Placeholder', 'wp_dastak'),
							'name'        => 'placeholder',
							'validation'  => '',
						),
						array(
							'type'  		=> 'textbox',
							'label'       => __('Class Attribute', 'wp_dastak'),
							'name'        => 'class',
							'validation'  => '',
						),
						array(
							'type'  		=> 'textbox',
							'label'       => __('Field Container Class Attribute', 'wp_dastak'),
							'name'        => 'container_class',
							'validation'  => '',
						),
						array(
							'type'  		=> 'textbox',
							'label'       => __('id Attribute', 'wp_dastak'),
							'name'        => 'id',
							'validation'  => '',
						),
					),
					
				),
				
	),
);




/**
 * EOF
 */
 
 
 return $options;
 
 
 
 
 
 
 
 