<?php

VP_Security::instance()->whitelist_function('vp_copy_content');

function vp_copy_content($value, $value2)
{
	$args = func_get_args();
	return implode('', $args);
}

VP_Security::instance()->whitelist_function('vp_simple_shortcode');

function vp_simple_shortcode($name = "", $url = "", $image = "")
{
	if(is_null($name))  $name = '';
	if(is_null($url))   $url = '';
	if(is_null($image)) $image = '';
	$result = "[shortcode name='$name' url='$url' image='$image']";
	return $result;
}

VP_Security::instance()->whitelist_function('vp_bind_bigcontinents');

function vp_bind_bigcontinents()
{
	$bigcontinents = array(
		'Eurafrasia',
		'America',
		'Oceania',
	);

	$result = array();

	foreach ($bigcontinents as $data)
	{
		$result[] = array('value' => $data, 'label' => $data, 'img' => 'http://placehold.it/100x100');
	}

	return $result;
}

VP_Security::instance()->whitelist_function('vp_bind_continents');

function vp_bind_continents($param = '')
{
	$continents = array(
		'Eurafrasia' => array(
			'Africa',
			'Asia',
			'Europe'
		),
		'America' => array(
			'North America',
			'Central America and the Antilles',
			'South America'
		),
		'Oceania' => array(
			'Australasia',
			'Melanesia',
			'Micronesia',
			'Polynesia',
		),
	);

	$result = array();
	$datas  = array();

	if(is_array($param))
		$param = reset($param);

	if(array_key_exists($param, $continents))
		$datas = $continents[$param];

	foreach ($datas as $data)
	{
		$result[] = array('value' => $data, 'label' => $data, 'img' => 'http://placehold.it/100x100');
	}

	return $result;
}

VP_Security::instance()->whitelist_function('vp_bind_countries');

function vp_bind_countries($param = '')
{
	$countries = array(
		'Africa' => array(
			'Algeria',
			'Nigeria',
			'Egypt',
		),
		'Asia' => array(
			'Indonesia',
			'Malaysia',
			'China',
			'Japan',
		),
		'Europe' => array(
			'France',
			'Germany',
			'Italy',
			'Netherlands',
		),
		'North America' => array(
			'United States',
			'Mexico',
			'Canada',
		),
		'Central America and the Antilles' => array(
			'Cuba',
			'Guatemala',
			'Haiti',
		),
		'South America' => array(
			'Argentina',
			'Brazil',
			'Paraguay',
		),
		'Australasia' => array(
			'Australia',
			'New Zealand',
			'Christmas Island',
		),
		'Melanesia' => array(
			'Fiji',
			'Papua New Guinea',
			'Vanuatu',
		),
		'Micronesia' => array(
			'Guam',
			'Nauru',
			'Palau'
		),
		'Polynesia' => array(
			'American Samoa',
			'Samoa',
			'Tokelau',
		),
	);
	$result = array();
	$datas  = array();

	if(is_null($param))
		$param = '';

	if(is_array($param) and !empty($param))
		$param = reset($param);

	if(empty($param))
		$param = '';

	if(array_key_exists($param, $countries))
		$datas = $countries[$param];

	foreach ($datas as $data)
	{
		$result[] = array('value' => $data, 'label' => $data, 'img' => 'http://placehold.it/100x100');
	}

	return $result;
}

VP_Security::instance()->whitelist_function('vp_dep_is_keyword');

function vp_dep_is_keyword($value)
{
	if($value === 'keyword')
		return true;
	return false;
}

VP_Security::instance()->whitelist_function('vp_dep_is_tags');

function vp_dep_is_tags($value)
{
	if($value === 'tags')
		return true;
	return false;
}

VP_Security::instance()->whitelist_function('vp_dep_is_logo');

function vp_dep_is_logo($value)
{
	if($value === 'image')
		return true;
	return false;
}
VP_Security::instance()->whitelist_function('vp_dep_is_text');
function vp_dep_is_text($value)
{
	if($value === 'text')
		return true;
	return false;
}

VP_Security::instance()->whitelist_function('vp_bind_color_accent');

function vp_bind_color_accent($preset)
{
	switch ($preset) {
		case 'red':
			return '#ff0000';
		case 'green':
			return '#00ff00';
		case 'blue':
			return '#0000ff';
		default:
			return '#000000';
	}
}

VP_Security::instance()->whitelist_function('vp_bind_color_subtle');

function vp_bind_color_subtle($preset)
{
	return vp_bind_color_accent($preset);
}

VP_Security::instance()->whitelist_function('vp_bind_color_background');

function vp_bind_color_background($preset)
{
	return vp_bind_color_accent($preset);
}

VP_Security::instance()->whitelist_function('vp_font_preview');

function vp_font_preview($face, $color, $size) {
    $gwf = new VP_Site_GoogleWebFont();
    $gwf->add($face);
    $links = $gwf->get_font_links();
    $link = reset($links);
    $dom = '';
    $dom = "<link href=" . $link . " rel='stylesheet' type='text/css'>
  <div class='font_preivew'><p style='padding: 0 10px 0 10px; font-family: " . $face . "; color: " . $color . ";font-size: " . $size . "px;'>";
    $dom .= __('1 2 3 4 5 6 7 8 9 0 A B C D E F G H I J K L M N O P Q R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t u v w x y z', 'wp_dastak') . '</p></div>';
    return $dom;
}

VP_Security::instance()->whitelist_function('vp_dep_sidebar_boolean');

function vp_dep_sidebar_boolean($value)
{
	if( $value == 'full' ) return false;
	else return true;
}

/*VP_Security::instance()->whitelist_function('vp_dep_boolean');

function vp_dep_boolean($value)
{
	if( $value == true ) return false;
	else return true;
}*/


VP_Security::instance()->whitelist_function('sh_dep_pb_dropdown');
function sh_dep_pb_dropdown($value)
{
	if( $value == 'select' ) return true;
	else return false;
}

VP_Security::instance()->whitelist_function('sh_dep_pb_checkbox');
function sh_dep_pb_checkbox($value)
{
	if( $value == 'checkbox' ) return true;
	else return false;
}

VP_Security::instance()->whitelist_function('sh_dep_pb_radio');
function sh_dep_pb_radio($value)
{
	if( $value == 'radio' ) return true;
	else return false;
}

VP_Security::instance()->whitelist_function('vp_dep_is_boxed');

function vp_dep_is_boxed($value)
{
	if($value === 'boxed')
		return true;
	return false;
}

VP_Security::instance()->whitelist_function('vp_dep_is_style1');

function vp_dep_is_style1($value)
{
	if($value === 'style1')
		return true;
	return false;
}

VP_Security::instance()->whitelist_function('vp_dep_is_custom');

function vp_dep_is_custom($value)
{
	if($value === 'custom')
		return true;
	return false;
}

VP_Security::instance()->whitelist_function('vp_dep_is_default');

function vp_dep_is_default($value)
{
	if($value === 'default')
		return true;
	return false;
}

/*VP_Security::instance()->whitelist_function('vp_dep_is_boolean');

function vp_dep_is_boolean($value)
{
	if($value === 'boolean')
		return true;
	return false;
}*/

VP_Security::instance()->whitelist_function('vp_dep_is_style4');

function vp_dep_is_style4($value)
{
	if($value === 'style4')
		return true;
	return false;
}

VP_Security::instance()->whitelist_function('vp_dep_is_style3');

function vp_dep_is_style3($value)
{
	if($value === 'style3')
		return true;
	return false;
}

VP_Security::instance()->whitelist_function('vp_dep_is_image');

function vp_dep_is_image($value)
{
	if($value === 'image')
		return true;
	return false;
}

VP_Security::instance()->whitelist_function('vp_dep_is_pattern');

function vp_dep_is_pattern($value)
{
	if($value === 'pattern')
		return true;
	return false;
}

function vp_megamenu_container_shortcode($style = "", $position = "", $imageleft = "", $imageright = "", $color= "", $content = "" )
{
	if(is_null($style)) $style = '';
	if(is_null($position)) $position = '';
	if(is_null($imageleft)) $imageleft = '';
	if(is_null($imageright)) $imageright = '';
	if(is_null($content)) $content = '';
	if(is_null($color)) $color = '';
	$result = "[megamenu_container_shortcode style='$style' position='$position' imageleft='$imageleft' imageright='$imageright' color='$color']".$content."[/megamenu_container_shortcode]"; 
	return $result;
}
VP_Security::instance()->whitelist_function('vp_megamenu_container_shortcode');

function vp_custom_menu_shortcode($title = "", $menu = "", $cols = "")
{
	if(is_null($title)) $title = '';
	if(is_null($menu)) $menu = '';
	if(is_null($cols)) $cols = '';
	
	$result = "[custom_menu_shortcode title='$title' cols='$cols' menu='$menu']"; 
	return $result;
}
VP_Security::instance()->whitelist_function('vp_custom_menu_shortcode');

function vp_custom_content_shortcode($title = "", $description = "", $cols = "", $label="", $url="")
{
	if(is_null($title)) $title = '';
	if(is_null($description)) $description = '';
	if(is_null($label)) $label = '';
	if(is_null($url)) $url = '';
	if(is_null($cols)) $cols = '';
	
	$result = "[custom_content_shortcode title='$title' description='$description' cols='$cols' label='$label' url='$url']"; 
	return $result;
}
VP_Security::instance()->whitelist_function('vp_custom_carousel_shortcode');

function vp_custom_carousel_shortcode($title = "", $post_type = "", $cols = "", $num = '')
{
	if(is_null($title)) $title = '';
	if(is_null($post_type)) $post_type = '';
	if(is_null($cols)) $cols = '';
	if(is_null($num)) $num = '';
	$result = "[custom_carousel_shortcode title='$title' post_type='$post_type' cols='$cols' num='$num']"; 
	return $result;
}
VP_Security::instance()->whitelist_function('vp_custom_carousel_shortcode');


