<?php global $wp_query;
ob_start(); ?>

<?php if( $style == 'heading' ): ?>
	
    <div class="clearfix"></div>
    
	<div class="general-title<?php if( $center ) echo ' text-center'; ?>">
        <h3><?php echo $title; ?></h3>
        
        <?php if( $sub_title ): ?> 
        	<p><?php echo $sub_title; ?></p>
        <?php endif; ?>
        <hr>
        
    </div>

<?php endif; ?>

<?php if( $style == 'black_box_img' ): ?>
	
    <div class="clearfix"></div>
    
	<section class="marketplace-top">
        <div id="market-wrapper">
            <div class="container">
                
                <div class="marketplace-top-shadow">
                    <span class="s1"></span>
                </div>
                
                <header class="text-center">
                    
                    <h1><?php echo $title; ?></h1>
                    <p class="mbuttons">
                        <?php if( $btn_label ): ?>
                        	<a href="<?php echo esc_url($btn_link); ?>" class="dmbutton"><?php echo $btn_label; ?></a>
                        <?php endif; ?>
                        <?php if( $btn1_label ): ?>
                        	<a href="<?php echo esc_url($btn1_link); ?>" class="dmbutton"><?php echo $btn1_label; ?></a>
                        <?php endif; ?>
                    </p>
					<?php if( $img ): ?>
                        <img alt="image" src="<?php echo wp_get_attachment_url($img); ?>" class="aligncenter effect-fade in" data-effect="fade" style="transition: all 0.7s ease-in-out 0s;">
                    <?php endif; ?>
                    
                </header>
            </div>
		</div><!-- end post-wrapper-top -->
    </section>

<?php endif; ?>


<?php if( $style == 'black_box' ): ?>
	
    <div class="clearfix"></div>
    
	<section class="section2">
    
    	<div class="message text-center">
            <h2 class="big-title"><?php echo $title; ?></h2>
            <?php if( $desc ): ?>
            	<p class="small-title"><?php echo $desc; ?></p>
            <?php endif; ?>
            
			<?php if( $btn_label ): ?>
            	<a href="<?php echo esc_url($btn_link); ?>" class="button large"><?php echo $btn_label; ?></a>
            <?php endif; ?>
            
			<?php if( $btn1_label ): ?>
            	&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
            	<a href="<?php echo esc_url($btn1_link); ?>" class=" dmbutton large"><?php echo $btn1_label; ?></a>
            <?php endif; ?>
		</div>
	</section>

<?php endif; ?>

<?php if($style == 'video_box'):?>
	<?php $image = ($background_image) ? 'style="background-image:url('.wp_get_attachment_url($background_image).');"' : '';?>
	<div class="<?php echo esc_attr($parallax);?> parallax">
        <div class="fixed-img sec-bg2" <?php echo $image;?>></div>
        <div class="container">
            <div class="row">
                <div class="col-md-6">
                    <div class="video-paralax">
                        <h3><?php echo $title;?> <i><?php echo $sub_title;?></i></h3>
                        <p><?php echo $description;?></p>
                        <a href="<?php echo esc_url($url);?>" title="<?php echo esc_attr($label);?>"><?php echo $label;?></a>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="video-frame">
                        <?php echo $contents;?>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php endif;?>

<?php if($style == 'promotional_video'):
	global $wp_embed;?>
    <div class="promote-video">
			
        <div class="row">
            <div class="col-md-6">
                <div class="video-frame">
                    <?php echo $wp_embed->run_shortcode('[embed width="870" height="408"]'.$contents.'[/embed]');?>
                </div>
            </div>
            <div class="col-md-6 slideinright">
                <?php echo ($sub_title) ? '<h3>'.$sub_title.'</h3>' : ''?>
               	<p><?php echo $description;?></p>
                <?php echo ($location) ? '<span><i class="fa fa-user"></i>'.$location.'</span>' : '';?>
                <?php echo ($date) ? '<span><i class="fa fa-calendar-o"></i>'.$date.'</span>' : '';?>
            </div>
        </div>
		</div>

<?php endif;?>

<?php if($style == 'contact_box'):?>

	<?php $bgimage = ($background_image) ? 'style="background-image:url('.wp_get_attachment_url($background_image).');"' : '';?>
	<div class="toll-free-sec">
        <a title=""><span class="fa fa-phone"></span></a>
        <div class="toll-free-banner">
            <div class="toll-contact">
                <i class="fa fa-phone"></i>
                <span><?php echo $sub_title;?> <i><?php echo $phone;?></i></span>
            </div>
            <div class="toll-details" <?php echo $bgimage;?>>
                <span><img src="<?php echo wp_get_attachment_url($image, '370x370'); ?>" alt="<?php echo esc_attr($title);?>" /></span>
                <h3><?php echo $title;?></h3>
                <p><?php echo $description;?></p>
                <?php echo ($label1) ? '<a href="'.$url1.'" title="'.$label1.'"><i class="fa fa-play-circle-o"></i>'.$label1.'</a>' : '';?>
                <?php echo ($label2) ? '<a href="'.$url2.'" title="'.$label2.'"><i class="fa fa-play-circle-o"></i>'.$label2.'</a>' : '';?>
            </div> 
        </div>
	</div>
<?php endif;?>

<?php if($style == 'content_box'):?>

	<?php echo ($title) ? '<div class="heading1">'.sh_get_title($title, true).'</div>' : '';?>
		
		<div class="row">
        	<?php if($slides):?>
            	<?php $slides_images = explode(',', $slides); ?>
                <div class="col-md-6">
                    <ul id="who-we-images">
                    	<?php foreach($slides_images as $slide):?>
                        	<li><?php echo wp_get_attachment_image($slide, '570x350'); ?></li>
                        <?php endforeach;?>
                    </ul>
                </div>
            <?php endif;?>
			<div class="col-md-6">
				<div class="who-we-desc">
					<h3><?php echo $sub_title;?></h3>
					
					<p><?php echo $description;?></p>
					
					<?php echo ($label) ? '<a href="'.$url.'" title="'.$label.'">'.$label.'</a>' : '';?>
				</div>
			</div>
			
		</div>
<script type="text/javascript">
	jQuery(document).ready(function($) {
		$("#who-we-images").owlCarousel({
				autoPlay :true,
				stopOnHover : true,
				goToFirstSpeed : 2000,
				slideSpeed:4000,
				singleItem : true,
				autoHeight : true,
				transitionStyle:"fadeUp",
				navigation:false
				});	
	});
</script>
<?php endif;?>

<?php if($style == 'content_box_two'):?>

	<?php $bgimage = ($image) ? 'style="background-image:url('.wp_get_attachment_url($image).');"' : '';?>

    <div class="<?php echo esc_attr($parallax);?> parallax">
        <div class="fixed-img sec-bg2" <?php echo $bgimage;?>></div>
        <div class="container">
            <div class="buy-a-ticket">
                <?php echo ($title) ? '<h3>'.$title.' <i>'.$sub_title.'</i></h3>' : '';?>
                <p><?php echo $description?></p>
                <?php echo ($label) ? '<a href="'.esc_url($url).'" title="'.esc_attr($label).'">'.$label.'</a>' : '';?>
            </div>
        </div>
    </div>
       
    
<?php endif;?>

<?php if($style == 'content_box_three'):?>
    
    
    <div class="tab-work">
        <span><?php echo wp_get_attachment_image($image);?></span>
        <p><?php echo $description;?></p>
        <?php echo ($label) ? '<a href="'.$url.'" title="'.$label.'">'.$label.'</a>' : '' ?>
    </div>
    
<?php endif;?>

<?php if($style == 'content_box_four'):?>

	<div class="about-sec">
        <div class="row">
            <div class="col-md-6 slideinleft">
                <?php echo wp_get_attachment_image($image, '570x350');?>
            </div>
            <div class="col-md-6 slideinright">
                <?php echo '<h3>'.$title.'</h3>';?>
                <p><?php echo $description;?></p>
                <?php echo ($label) ? '<a href="'.$url.'" title="'.$label.'">'.$label.'</a>' : '';?>
            </div>
        </div>
	</div>
    
<?php endif;?>

<?php if($style == 'twitter_carousel'):?>
	<?php wp_enqueue_script('custom-tweets');?>
	<?php SH_Twitter(array('screen_name'=>$id, 'count'=>$num, 'selector'=>'.twitter-bar-slide', 'template' => 'list'));?>
    <?php $bgimage = ($image) ? 'style="background-image:url('.wp_get_attachment_url($image).');"' : '';?>
    <div class="<?php echo esc_attr($parallax);?>">
		<div class="fixed-img sec-bg2" <?php echo $bgimage;?>></div>
		<div class="container">
			<ul class="twitter-bar-slide">
			</ul>
			<a href="<?php if( $id ) echo 'http://twitter.com/'.$id; ?>" id="twitter-btn" title=""><?php _e('Follow Us', 'wp_dastak');?></a>
		</div>
	</div>
<?php endif;?>

<?php if($style == 'twitter_carousel_two'):?>
	<?php wp_enqueue_script('custom-tweets');?>
	<?php
		SH_Twitter(array('template'=>'li','screen_name'=>$id, 'count'=>$num, 'selector'=>'#twitter-widget'));
	?>
    <?php $bgimage = ($image) ? 'style="background-image:url('.wp_get_attachment_url($image).');"' : '';?>
    
    <div class="s-twitter-widget">
       
            <?php echo ($title) ? '<div class="heading2">'.sh_get_title($title).'</div>' : ''; ?>
       
        <div class="twitter-widget" <?php echo esc_attr($bgimage);?>>
            <ul id="twitter-widget">
            </ul>
            <a href="<?php if( $id ) echo 'http://twitter.com/'.$id; ?>" title="<?php echo esc_attr($label);?>"><?php echo $label;?></a>
        </div>
        
    </div>
    
<?php endif;?>

<?php if($style == 'flickr_feeds'):?>
	<?php wp_enqueue_script('flickr');?>
	<div class="s-flicr-widget">
        <div class="row">
            
            
        </div>
    </div>
    <script type="text/javascript">
        jQuery(document).ready(function($) {
            $('.s-flicr-widget .row').jflickrfeed({
                limit: <?php echo $num;?> ,
                qstrings: {id: '<?php echo $id ?>'},
                itemTemplate: '<div class="col-md-4"><a href="{{link}}" title="{{title}}"><img src="{{image_s}}" alt="{{title}}" /></a></div>'
            });
        });
   	</script>
    
<?php endif;?>

<?php if($style == 'ceo_box'):?>
	<div class="about-ceo-sec2 row">
        <div class="ceo-detals2 col-md-12 style2 bouncein">
            <h3>---  <i><?php echo $title;?></i> -- <?php echo $designation;?></h3>
            <p>&ldquo; <?php echo $description;?> &rdquo;</p>
        </div>
    </div>
<?php endif;?>

<?php if($style == 'ceo_box2'):?>
         
    <div class="w-ceo">
        <?php echo wp_get_attachment_image($image, '370x370');?>
        <h5><?php echo $name;?></h5>
        <p><?php echo $description;?></p>
    </div>
<?php endif;?>

<?php if($style == 'content_box_parallax'):?>
	<?php $background = ($bg) ? 'style="background:url('.wp_get_attachment_url($bg, 'full').')"' : '';?>
    <div class="<?php echo esc_attr($parallax);?> parallax">
        <div class="fixed-img sec-bg19" <?php echo $background;?>></div>
        <div class="container">
            <div class="row">
                <div class="col-md-6">
                    <div class="parallax-about-law">
                        <?php echo ($title1) ? '<h3 class="parallax-sub-heading"><i class="fa '.$icon1.'"></i>'.$title1.'</h3>' : '';?>
                        <p><?php echo $description;?></p>
                        <?php echo ($label) ? '<a href="'.$url.'" title="'.$label.'">'.$label.'</a>' : '';?>
                    </div>
                </div>
                
                <div class="col-md-6">
                    <div class="parallax-features">
                            <?php echo ($title2) ? '<h3 class="parallax-sub-heading"><i class="fa '.$icon2.'"></i>'.$title2.'</h3>' : '';?>
                        <ul>
                            <?php echo do_shortcode($contents);?>
                        </ul>
                    </div>
                </div>
                
            </div>
        </div>
    </div>
	
<?php endif;?>

<?php if($style == 'contents_list'):?>

	<?php echo '<li><i class="fa fa-angle-right"></i> <p>'.$contents.'</p></li>';?>
	
<?php endif;?>
	
<?php $output = ob_get_contents();
ob_end_clean(); ?>