<?php

/// Recent Posts
class SH_Recent_Post extends WP_Widget
{
	/** constructor */
	function __construct()
	{
		parent::__construct( /* Base ID */'SH_Recent_Post', /* Name */__('Dastak Recent Posts ','wp_dastak'), array( 'description' => __('Show the recent posts with images', 'wp_dastak' )) );
	}
 

	/** @see WP_Widget::widget */
	function widget($args, $instance)
	{
		extract( $args );
		$title = apply_filters( 'widget_title', $instance['title'] );
		
		echo $before_widget;
		
		$con_title = explode(' ', $title, 2);
		
		if(count($con_title) > 1){
			$title = $con_title[0].' <i>'.$con_title[1].'</i>';
		}else{
			$title = $con_title[0];
		}
		
		$widget_title = $before_title.$title.$after_title; 
		
		$query_string = 'posts_per_page='.$instance['number'];
		if( $instance['cat'] ) $query_string .= '&cat='.$instance['cat'];
		query_posts( $query_string ); 
	
		$this->posts($widget_title);
		wp_reset_query(); 
		
		echo $after_widget;
	}
 
 
	/** @see WP_Widget::update */
	function update($new_instance, $old_instance)
	{
		$instance = $old_instance;
		
		$instance['title'] = $new_instance['title'];
		$instance['number'] = $new_instance['number'];
		$instance['cat'] = $new_instance['cat'];
		
		return $instance;
	}

	/** @see WP_Widget::form */
	function form($instance)
	{
		$title = ( $instance ) ? esc_attr($instance['title']) : __('Recent Posts', 'wp_dastak');
		$number = ( $instance ) ? esc_attr($instance['number']) : 4;
		$cat = ( $instance ) ? esc_attr($instance['cat']) : '';?>
			
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title: ', 'wp_dastak'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" />
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('number'); ?>"><?php _e('No. of Posts:', 'wp_dastak'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('number'); ?>" name="<?php echo $this->get_field_name('number'); ?>" type="text" value="<?php echo $number; ?>" />
        </p>
       
        <p>
            <label for="<?php echo $this->get_field_id('cat'); ?>"><?php _e('Category', 'wp_dastak'); ?></label>
            <?php wp_dropdown_categories( array('show_option_all'=>'All', 'selected'=>$cat, 'class'=>'widefat') ); ?>
        </p>
        
		<?php 
	}
	
	function posts($title)
	{
		
		if( have_posts() ):?>
        
        	<div class="f-recent-office">
                <?php echo $title;?>
                <ul>
                	<?php while( have_posts() ): the_post(); ?>
                        <li <?php post_class(); ?>>
                            <span><?php the_post_thumbnail('thumbnail'); ?></span>
                            <a href="<?php the_permalink();?>" title="<?php the_title();?>"><?php echo character_limiter( get_the_title(), 30 ); ?><i><?php echo __('Posted', 'wp_dastak').' '. date(get_option('date_format'), strtotime(get_the_date()));?></i></a>
                            <strong><?php _e('By', 'wp_dastak').' '. the_author();?></strong>
                        </li>
                    <?php endwhile;?>
                </ul>
            </div>
            
		<?php endif;
		wp_reset_query();
    }
}

/// Testimonials
class SH_Testimonials extends WP_Widget
{
	/** constructor */
	function __construct()
	{
		parent::__construct( /* Base ID */'SH_Testimonials', /* Name */__('Dastak Tesimonials ','wp_dastak'), array( 'description' => __('Show the testimonials', 'wp_dastak' )) );
	}
 

	/** @see WP_Widget::widget */
	function widget($args, $instance)
	{
		extract( $args );
		$title = apply_filters( 'widget_title', $instance['title'] );
		
		$con_title = explode(' ', $title, 2);
		
		if(count($con_title) > 1){
			$title = $con_title[0].' <i>'.$con_title[1].'</i>';
		}else{
			$title = $con_title[0];
		}
		
		echo $before_widget;
		
		echo $before_title.$title.$after_title; 
		
		$args = array('post_type'=>'sh_testimonial', 'posts_per_page'=>sh_set($instance, 'number'));
		if( sh_set($instance, 'cat') ) $args['cat'] = sh_set($instance, 'cat');
		$widget_location = sh_set($instance, 'location');
		query_posts( $args ); 
	
		$this->testimonials($widget_location);
		wp_reset_query(); 
		
		echo $after_widget;
	}
 
 
	/** @see WP_Widget::update */
	function update($new_instance, $old_instance)
	{
		$instance = $old_instance;
		
		$instance['title'] = $new_instance['title'];
		$instance['number'] = $new_instance['number'];
		$instance['cat'] = $new_instance['cat'];
		$instance['location'] = $new_instance['location'];
		
		return $instance;
	}

	/** @see WP_Widget::form */
	function form($instance)
	{
		$title = ( $instance ) ? esc_attr($instance['title']) : __('Our Testimonials', 'wp_dastak');
		$number = ( $instance ) ? esc_attr($instance['number']) : 4;
		$cat = ( $instance ) ? esc_attr($instance['cat']) : '';
		$location = ( $instance ) ? esc_attr(sh_set($instance, 'location')) : 'sidebar';?>
			
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title: ', 'wp_dastak'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" />
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('number'); ?>"><?php _e('No. of Testimonials:', 'wp_dastak'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('number'); ?>" name="<?php echo $this->get_field_name('number'); ?>" type="text" value="<?php echo $number; ?>" />
        </p>
       
        <p>
            <label for="<?php echo $this->get_field_id('cat'); ?>"><?php _e('Category', 'wp_dastak'); ?></label>
            <?php wp_dropdown_categories( array('show_option_all'=>'All', 'selected'=>$cat, 'class'=>'widefat', 'taxonomy'=>'testimonial_category') ); ?>
        </p>
        
         <p>
            <label for="<?php echo $this->get_field_id('location'); ?>"><?php _e('Widget Location', 'wp_dastak'); ?></label>
            <select name="<?php echo $this->get_field_name('location'); ?>">
            	<option <?php echo($location == 'sidebar') ? 'selected="selected"' : '';?> value="sidebar"><?php _e('Sidebar', 'wp_dastak');?></option>
                <option <?php echo($location == 'footer') ? 'selected="selected"' : '';?> value="footer"><?php _e('Footer', 'wp_dastak');?></option>
            </select>
        </p>
        
		<?php 
	}
	
	function testimonials($widget_location)
	{
		
		if( have_posts() ):?>
      
        	<div class="f-testimonail <?php echo ($widget_location == 'sidebar') ? 'with-white' : '';?>" >
					
					<div class="f-testimonial-slide-sec">
						<ul class="nav nav-tabs f-testimonial-slide">
                     
                       	<?php $i =1;?>
                        
                    	<?php while( have_posts() ): the_post(); ?>
					  		<li <?php echo ($i==1) ? 'class="active"' : '';?>><a data-toggle="tab" href="#f-testimonial<?php  echo ($widget_location == 'sidebar') ? $i : 'sec'.$i;?>">
					  		<?php the_post_thumbnail('thumbnail');?></a></li>
                            <?php $i++;?>
					  	<?php endwhile;?>
                        
						</ul>
					</div>
					<div class="tab-content">
                    	<?php $i =1;?>
                    	<?php while( have_posts() ): the_post(); ?>
                          <div id="f-testimonial<?php  echo ($widget_location == 'sidebar') ? $i : 'sec'.$i;?>" class="tab-pane fade <?php echo ($i==1) ? 'in active' : '';?>">
                            
                            <div class="f-testimonial-box">
                                <h4><?php the_title();?><i><?php echo date(get_option('date_format', get_the_date()))?></i></h4>
                                <p><?php echo character_limiter( get_the_content(), 80 ); ?></p>
                            </div>
                          
                          </div>
                          <?php $i++;?>
                       <?php endwhile;?>
					</div>
				</div>
                
                <script type="text/javascript">
					jQuery(document).ready(function($) {
						$(".f-testimonial-slide").owlCarousel({
							autoPlay :true,
							stopOnHover : true,
							goToFirstSpeed : 2000,
							slideSpeed:1500,
							items : 3,
							autoHeight : true,
							transitionStyle:"goDown",
							navigation:false
						});	
					});
				</script>
            
		<?php endif;
		wp_reset_query();
    }
}

/// Testimonials
class SH_Recent_Work extends WP_Widget
{
	/** constructor */
	function __construct()
	{
		parent::__construct( /* Base ID */'SH_Recent_Work', /* Name */__('Dastak Recent Work','wp_dastak'), array( 'description' => __('Show the recnet work', 'wp_dastak' )) );
	}
 

	/** @see WP_Widget::widget */
	function widget($args, $instance)
	{
		extract( $args );
		$title = apply_filters( 'widget_title', $instance['title'] );
		
		$con_title = explode(' ', $title, 2);
		
		if(count($con_title) > 1){
			$title = $con_title[0].' <i>'.$con_title[1].'</i>';
		}else{
			$title = $con_title[0];
		}
		
		echo $before_widget;
		
		$widget_title = $before_title.$title.$after_title; 
		
		$args = array('post_type'=>'sh_portfolio', 'posts_per_page'=>sh_set($instance, 'number'));
		if( sh_set($instance, 'cat') ) $args['cat'] = sh_set($instance, 'cat');
		
		query_posts( $args ); 
	
		$this->work($widget_title, sh_set($instance, 'number'));
		wp_reset_query(); 
		
		echo $after_widget;
	}
 
 
	/** @see WP_Widget::update */
	function update($new_instance, $old_instance)
	{
		$instance = $old_instance;
		
		$instance['title'] = $new_instance['title'];
		$instance['number'] = $new_instance['number'];
		$instance['cat'] = $new_instance['cat'];
		
		return $instance;
	}

	/** @see WP_Widget::form */
	function form($instance)
	{
		$title = ( $instance ) ? esc_attr($instance['title']) : __('Recent Work', 'wp_dastak');
		$number = ( $instance ) ? esc_attr($instance['number']) : 4;
		$cat = ( $instance ) ? esc_attr($instance['cat']) : '';?>
			
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title: ', 'wp_dastak'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" />
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('number'); ?>"><?php _e('No. of Posts:', 'wp_dastak'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('number'); ?>" name="<?php echo $this->get_field_name('number'); ?>" type="text" value="<?php echo $number; ?>" />
        </p>
       
        <p>
            <label for="<?php echo $this->get_field_id('cat'); ?>"><?php _e('Category', 'wp_dastak'); ?></label>
            <?php wp_dropdown_categories( array('show_option_all'=>'All', 'selected'=>$cat, 'class'=>'widefat', 'taxonomy'=>'portfolio_category') ); ?>
        </p>
        
		<?php 
	}
	
	function work($title, $num)
	{
		
		if( have_posts() ):?>
        
        	<div class="s-related-widget">
               
                    <?php echo $title;?> 
                
					<div id="related-project">
                    	<div class="row">
                        <?php $i=1;?>
                    	<?php while(have_posts()):the_post();?>
						
							<div class="col-md-12">
								<div class="related-project">
									<div class="related-thumb">
										<?php the_post_thumbnail('870x347')?>
                                        <?php $day = date('d', strtotime(get_the_date())); ?>
                                		<?php $month = date('M', strtotime(get_the_date())); ?>
										<span><?php echo $day;?><i><?php echo $month;?></i></span>
										<a href="<?php the_permalink();?>" title="<?php the_title();?>"><i class="fa fa-link"></i></a>
									</div>
									<h3><a href="<?php the_permalink();?>" title="<?php the_title();?>"><?php the_title();?></a></h3>
									<p><?php echo character_limiter( get_the_content(), 60 ); ?></p>
								</div>
							</div>
                            <?php if($i%2 == 0 && $i!= $num):?>
                            	</div><div class="row">
                            <?php endif;?>
                            <?php $i++;?>
						<?php endwhile;?>
                        <?php wp_reset_query();?>	
						</div>
					</div>
				</div>
                
            <script type="text/javascript">
				jQuery(document).ready(function($) {
				
					$("#related-project").owlCarousel({
						autoPlay :true,
						stopOnHover : true,
						goToFirstSpeed : 2000,
						slideSpeed:1500,
						singleItem : true,
						autoHeight : true,
						transitionStyle:"goDown",
						navigation:true
					});	
				});
			</script>
            
		<?php endif;
    }
}

/// Our Office
class SH_Our_Office extends WP_Widget
{
	/** constructor */
	function __construct()
	{
		parent::__construct( /* Base ID */'SH_Our_Office', /* Name */__('Dastak Our Office ','wp_dastak'), array( 'description' => __('Our Office', 'wp_dastak' )) );
	}
 

	/** @see WP_Widget::widget */
	function widget($args, $instance)
	{
		extract( $args );
		$title = apply_filters( 'widget_title', $instance['title'] );
		
		$con_title = explode(' ', $title, 2);
		
		if(count($con_title) > 1){
			$title = $con_title[0].' <i>'.$con_title[1].'</i>';
		}else{
			$title = $con_title[0];
		}
		
		echo $before_widget;
		
		
		?>
		
		<div class="f-find-office">
            <?php echo $before_title.$title.$after_title; ?>
            <span><img src="<?php echo sh_set($instance, 'image');?>" alt="" /></span>
            <ul>
                <li><i class="fa fa-map-marker"></i><p><?php echo sh_set($instance, 'address');?></p></li>
                <li><i class="fa fa-phone"></i><p><?php echo sh_set($instance, 'phone');?></p></li>
                <li><i class="fa fa-envelope"></i><p><?php echo sh_set($instance, 'email');?></p></li>
            </ul>
        </div>
	
		<?php 
		echo $after_widget;
	}
 
 
	/** @see WP_Widget::update */
	function update($new_instance, $old_instance)
	{
		$instance = $old_instance;
		
		$instance['title'] = $new_instance['title'];
		$instance['address'] = $new_instance['address'];
		$instance['image'] = $new_instance['image'];
		$instance['phone'] = $new_instance['phone'];
		$instance['email'] = $new_instance['email'];
		
		return $instance;
	}

	/** @see WP_Widget::form */
	function form($instance)
	{
		$title = ( $instance ) ? esc_attr($instance['title']) : __('Our Office', 'wp_dastak');
		$address = ( $instance ) ? esc_attr(sh_set($instance, 'address')) : '';
		$image = ( $instance ) ? esc_attr(sh_set($instance, 'image')) : '';
		$phone = ( $instance ) ? esc_attr(sh_set($instance, 'phone')) : '';
		$email = ( $instance ) ? esc_attr(sh_set($instance, 'email')) : '';
       
        
		?>
			
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title: ', 'wp_dastak'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" />
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('image'); ?>"><?php _e('Image URL', 'wp_dastak'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('image'); ?>" name="<?php echo $this->get_field_name('image'); ?>" type="text" value="<?php echo $image; ?>" />
        </p>
      
        <p>
            <label for="<?php echo $this->get_field_id('address'); ?>"><?php _e('Address:', 'wp_dastak'); ?></label>
            <textarea class="widefat" id="<?php echo $this->get_field_id('address'); ?>" name="<?php echo $this->get_field_name('address'); ?>" ><?php echo $address; ?></textarea>
        </p>
       
       	<p>
            <label for="<?php echo $this->get_field_id('phone'); ?>"><?php _e('Phone', 'wp_dastak'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('phone'); ?>" name="<?php echo $this->get_field_name('phone'); ?>" type="text" value="<?php echo $phone; ?>" />
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('email'); ?>"><?php _e('Email', 'wp_dastak'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('email'); ?>" name="<?php echo $this->get_field_name('email'); ?>" type="text" value="<?php echo $email; ?>" />
        </p>
        
		<?php 
	}
	
}

// Subscribe to our mailing list
class SH_feedburner extends WP_Widget
{
	/** constructor */
	function __construct()
	{
		parent::__construct( /* Base ID */'SH_subscribe_mail_list', /* Name */__('Dastak Subscribe Form','wp_dastak'), array( 'description' => __('create account on http://feedburner.com and allow users to subscribe OR you can also use Mailchimp option.', 'wp_dastak' )) );
	}

	/** @see WP_Widget::widget */
	function widget($args, $instance)
	{
		extract( $args );
		$title = apply_filters( 'widget_title', $instance['title'] );
		
		echo $before_widget;?>
        
        
         <div class="f-about-dastak">
            <?php echo (sh_set($instance, 'logo')) ? '<a href="'.home_url().'" title="'.get_bloginfo('name').'"><img src="'.sh_set($instance, 'logo').'" alt="'.get_bloginfo('name').'" /></a>' : '';?>
            <p><?php echo sh_set($instance, 'description');?></p>

           <?php $protocol = is_ssl() ? 'https' : 'http'; ?>
           <?php if ( $instance['form_type']  == 'Mailchimp' &&  $instance['mailchimpid'] ) : ?>
           			<div id="messages" class="form-message-subcribe"></div>
					<form id="news-ltr2" method="post">
						<input class="input-style" type="email" name="EMAIL" placeholder="<?php esc_attr_e( 'Enter Your Email Address', 'esperto' ); ?>" required/>
						<input type="hidden" name="thelist" value="<?php echo esc_attr( $instance['mailchimpid'] ); ?>" />

						<button class="submit" type="submit"><?php esc_html_e( 'Go', 'esperto' ); ?></button>

						<input type="hidden"  name="_wpnonce" value="<?php echo esc_attr(wp_create_nonce('dastak_wp_theme')); ?>" />
					</form>
                
                <?php
		$custom_script = 'jQuery(document).ready(function ($) {          
    		$( "form#news-ltr2").on( "submit", function ( e ) {                  
    			e.preventDefault();
    			var thisform = this,
    			button = $(this).find("button[type=submit]"),
    			button_txt = button.text();
    			
    			button.html( button_txt + " <i class=\'fa fa-refresh fa-spin\'></i>").attr(\'disabled\', \'disabled\');

    			var fields = $(thisform).serialize();
    			$.ajax({
    				type: "POST",
    				
    				data: fields + "&action=_sh_ajax_callback&subaction=dastak_newsletter",
    				url: ajaxurl,

    				success : function(response) {
    					$(".form-message-subcribe").html(response);
    					$(".form-message-subcribe").addClass("message-alert");
    					$(".form-message-subcribe").fadeIn();
    					setTimeout(function(){ 
    						$(".form-message-subcribe").fadeOut(100); }, 3000);

    						button.text(button_txt).removeAttr(\'disabled\');
    					},
    					fail: function(res) {
    						button.text(button_txt).removeAttr(\'disabled\');
    					}
    				});
    				return false;          
    			});            
    		});';
		wp_add_inline_script( 'custom-script', $custom_script );
                
            
         else : ?>
         <form target="popupwindow" method="post" action="<?php echo esc_attr($protocol); ?>://feedburner.google.com/fb/a/mailverify" accept-charset="utf-8">
           
            <input type="text" name="email" value="" placeholder="<?php _e("Email Address" , 'wp_dastak') ; ?>">
            <input type="hidden" name="uri" value="<?php echo $instance['ID']; ?>">
            <input type="hidden" value="en_US" name="loc">
            <input class="button" type="submit" name="submit" value="<?php _e("GO" , 'wp_dastak'); ?>">
            
        </form>
        <?php endif; ?>
        <?php if(sh_set($instance, 'social') == 'yes'):?>
        	<?php echo sh_get_social_icons('social-btns');?>
        <?php endif;?>
        <!--<ul class="social-btns">
            <li><a href="#" title=""><i class="fa fa-facebook"></i></a></li>
            <li><a href="#" title=""><i class="fa fa-twitter"></i></a></li>
            <li><a href="#" title=""><i class="fa fa-google-plus"></i></a></li>
            <li><a href="#" title=""><i class="fa fa-linkedin"></i></a></li>
            <li><a href="#" title=""><i class="fa fa-github"></i></a></li>
        </ul>-->
        </div>

       

		<?php
		
		echo $after_widget;
	}
	
	
	/** @see WP_Widget::update */
	function update($new_instance, $old_instance)
	{
		$instance = $old_instance;

		$instance['title'] = strip_tags($new_instance['title']);
		$instance['logo'] = strip_tags($new_instance['logo']);
		$instance['description'] = strip_tags($new_instance['description']);
		$instance['ID'] = $new_instance['ID'];
		$instance['form_type'] = $new_instance['form_type'];
		$instance['mailchimpid'] = $new_instance['mailchimpid'];
		
		return $instance;
	}

	/** @see WP_Widget::form */
	function form($instance)
	{
		$title = ($instance) ? esc_attr($instance['title']) : __('Subscribe to Our Mailing List', 'wp_dastak');
		$logo = ($instance) ? esc_attr(sh_set($instance, 'logo')) : '';
		$description = ($instance) ? esc_attr(sh_set($instance, 'description')) : '';
		$social = ($instance) ? esc_attr(sh_set($instance, 'social')) : '';
        $form_type = ($instance) ? esc_attr($instance['form_type']) : 'Feedburner';
         $mailchimpid = ($instance) ? esc_attr($instance['mailchimpid']) : '';
		$ID = ($instance) ? esc_attr($instance['ID']) : 'mixsms';?>
        
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:', 'wp_dastak'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" />
        </p>
        
         <p>
            <label for="<?php echo $this->get_field_id('logo'); ?>"><?php _e('Logo URL:', 'wp_dastak'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('logo'); ?>" name="<?php echo $this->get_field_name('logo'); ?>" type="text" value="<?php echo $logo; ?>" />
        </p>
        
        <p>
            <label for="<?php echo $this->get_field_id('description'); ?>"><?php _e('Description:', 'wp_dastak'); ?></label>
            <textarea class="widefat" id="<?php echo $this->get_field_id('description'); ?>" name="<?php echo $this->get_field_name('description'); ?>" ><?php echo $description; ?></textarea>
        </p>
         <p>
          <label for="<?php echo $this->get_field_id('text'); ?>">Form Type: 
            <select class='widefat' id="<?php echo $this->get_field_id('form_type'); ?>"
                    name="<?php echo $this->get_field_name('form_type'); ?>" type="text">
              <option value='Feedburner'<?php echo ($form_type=='Feedburner')?'selected':''; ?>>
                Feedburner
              </option>
              <option value='Mailchimp'<?php echo ($form_type=='Mailchimp')?'selected':''; ?>>
                Mailchimp
              </option> 
             
            </select>                
          </label>
         </p>
        <p>
            <label for="<?php echo $this->get_field_id('ID'); ?>"><?php _e('Feedburner ID:', 'wp_dastak'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('ID'); ?>" name="<?php echo $this->get_field_name('ID'); ?>" type="text" value="<?php echo $ID; ?>" />
        </p>
          <p>
            <label for="<?php echo $this->get_field_id('mailchimpid'); ?>"><?php _e('Mailchimp ID', 'wp_dastak'); ?></label>
           <?php $list_mail = dastak_get_mc_lists();
           if( $list_mail ) {
           ?>
          
  <select class="widefat" id="<?php echo $this->get_field_id('mailchimpid'); ?>"
                    name="<?php echo $this->get_field_name('mailchimpid'); ?>" type="text">
                    <?php foreach( $list_mail as $key => $value  ) { ?>
              <option value="<?php echo esc_attr($key); ?>">
                <?php echo $value; ?>
              </option>
             <?php } ?>
      
             
            </select>   


         <?php } ?> 
        </p>
         <p>
         	<input class="widefat" id="<?php echo $this->get_field_id('social'); ?>" name="<?php echo $this->get_field_name('social'); ?>" <?php echo ($social == 'yes') ? 'checked="checked"': '';?> type="checkbox" value="yes" />
            <label for="<?php echo $this->get_field_id('socail'); ?>"><?php _e('Show Social Icons:', 'wp_dastak'); ?></label>
            
        </p>
		<?php 
	}
}

// Flicker Gallery
class SH_Flickr extends WP_Widget
{
	function __construct()
	{
		parent::__construct( /* Base ID */'SH_Flickr', /* Name */__('Dastak Flickr Feed','wp_dastak'), array( 'description' => __('Fetch the latest feed from Flickr', 'wp_dastak' )) );
	}
	
	function widget($args, $instance)
	{
		extract( $args );
		$title = apply_filters( 'widget_title', $instance['title'] );

		$flickr_id = $instance['flickr_id'];
		$number = $instance['number'];
	
		echo $before_widget;

		
		
		$limit = ( $number ) ? $number : 6;?>
        		<?php wp_enqueue_script('flickr');?>
        		<div class="s-flicr-widget">
					<?php echo $before_title.$title.$after_title;?>
					<div class="row">
                    	
						
					</div>
				</div>
                <script type="text/javascript">
					jQuery(document).ready(function($) {
						$('.s-flicr-widget .row').jflickrfeed({
							limit: <?php echo $limit;?> ,
							qstrings: {id: '<?php echo $flickr_id ?>'},
							itemTemplate: '<div class="col-md-4"><a href="{{link}}" title="{{title}}"><img src="{{image_s}}" alt="{{title}}" /></a></div>'
						});
					});
			   </script>
            <?php
			
		echo $after_widget;
	}
	
	function update($new_instance, $old_instance)
	{
		$instance = $old_instance;
		
		$instance['title'] = strip_tags($new_instance['title']);

		$instance['flickr_id'] = $new_instance['flickr_id'];
		$instance['number'] = $new_instance['number'];
		
		return $instance;
	}
	
	function form($instance)
	{
		wp_enqueue_script('flickrjs');
		$title = ($instance) ? esc_attr($instance['title']) : __('Flicker', 'wp_dastak');
		$flickr_id = ($instance) ? esc_attr($instance['flickr_id']) : '';
		$number = ( $instance ) ? esc_attr($instance['number']) : 8;?>
		  
        <p>
            <label for="<?php echo $this->get_field_id('title');?>"><?php _e('Title:', 'wp_dastak');?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('title');?>" name="<?php echo $this->get_field_name('title');?>" type="text" value="<?php echo $title;?>" />
        </p>

        <p>
            <label for="<?php echo $this->get_field_id('flickr_id');?>"><?php _e('Flickr ID:', 'wp_dastak');?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('flickr_id');?>" name="<?php echo $this->get_field_name('flickr_id');?>" type="text" value="<?php echo $flickr_id;?>" />
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('number');?>"><?php _e('Number of Images:', 'wp_dastak');?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('number');?>" name="<?php echo $this->get_field_name('number');?>" type="text" value="<?php echo $number;?>" />
        </p>
        <?php 
	}
}

class SH_twitter extends WP_Widget
{
	/** constructor */
	function __construct()
	{
		parent::__construct( /* Base ID */ 'SH_twitter', /* Name */ 'Dastak Twitter', array( 'description' => 'Twitter tweets' ) );
	}

	/** @see WP_Widget::widget */
	function widget($args, $instance)
	{	
		extract( $args );
		$title = @apply_filters( 'widget_title', $instance['twitter_title'] );
		echo $before_widget;
		wp_enqueue_script('custom-tweets');		
		SH_Twitter(array('template'=>'li','screen_name'=>sh_set($instance, 'twitter_id'), 'count'=>sh_set($instance, 'tweets_num'), 'selector'=>'#twitter-widget'));
		
		$background = (sh_set($instance, 'bg')) ? 'style="background:url('.sh_set($instance, 'bg').');"' : '';
		
		?>
        
        
        
                <div class="s-twitter-widget">

                        <?php echo $before_title.$title.$after_title; ?>

                    <div class="twitter-widget" <?php echo $background;?>>
                        <ul id="twitter-widget">
                        </ul>
                        <a href="<?php if( sh_set($instance, 'twitter_id') ) echo 'http://twitter.com/'.sh_set($instance, 'twitter_id'); ?>" title="<?php _e('Follow Us on Twitter', 'wp_dastak');?>"><?php _e('Follow Us on Twitter', 'wp_dastak');?></a>
                    </div>
            
		</div>
		
		<?php
		echo $after_widget;
	}
	
	
	/** @see WP_Widget::update */
	function update( $new_instance, $old_instance )
	{
		$instance = $old_instance;
		$instance['twitter_title'] = strip_tags($new_instance['twitter_title']);
		$instance['twitter_id'] = strip_tags($new_instance['twitter_id']);
		$instance['tweets_num'] = strip_tags($new_instance['tweets_num']);
		$instance['bg'] = strip_tags($new_instance['bg']);

		return $instance;
	}

	/** @see WP_Widget::form */
	function form( $instance )
	{
		if ( $instance )
		{
			$twitter_title = esc_attr( $instance[ 'twitter_title' ] );
			$twitter_id = esc_attr($instance['twitter_id']);
			$tweets_num = esc_attr($instance['tweets_num']);
			$bg = ($instance) ? esc_attr(sh_set($instance, 'bg')) : '';

		}
		else
		{
			$twitter_title = _e( 'Latest Tweets', 'wp_dastak' );
			$twitter_id = 'wordpress';
			$tweets_num = 3;
			$bg = '';
			$follow_label = '';
		}
		
		wp_enqueue_style('thickbox');
 		wp_enqueue_script('media-upload');
  		wp_enqueue_script('thickbox');

	?> 
    	<p>   
            <label for="<?php echo $this->get_field_id('twitter_title'); ?>"><?php _e('Title:', 'wp_dastak'); ?></label> 
            <input class="widefat" id="<?php echo $this->get_field_id('twitter_title'); ?>" name="<?php echo $this->get_field_name('twitter_title'); ?>" type="text" value="<?php echo $twitter_title; ?>" />
       	</p>
        <p>
            <label for="<?php echo $this->get_field_id('twitter_id'); ?>"><?php _e('Twitter ID:', 'wp_dastak'); ?></label> 
            <input class="widefat" id="<?php echo $this->get_field_id('twitter_id'); ?>" name="<?php echo $this->get_field_name('twitter_id'); ?>" type="text" value="<?php echo $twitter_id; ?>" />
		</p>
        <p>
            <label for="<?php echo $this->get_field_id('tweets_num'); ?>"><?php _e('Number of Tweets:', 'wp_dastak'); ?></label> 
            <input class="widefat" id="<?php echo $this->get_field_id('tweets_num'); ?>" name="<?php echo $this->get_field_name('tweets_num'); ?>" type="text" value="<?php echo $tweets_num; ?>" />

		</p>
        <p>
          <label for="<?php echo $this->get_field_id('bg'); ?>"><?php _e('Background:', 'wp_dastak');?></label>
          <input type="text" class="img" name="<?php echo $this->get_field_name('bg'); ?>" id="<?php echo $this->get_field_id('bg'); ?>" value="<?php echo $bg; ?>" />
          <input type="button" class="select-img" value="<?php _e('Select Image', 'wp_dastak');?>" />
        </p>
        <script type="text/javascript">
			jQuery(function($){
			  $(document).on('click', 'input.select-img', function(evt){
				image_field = $(this).siblings('.img');
				tb_show('', 'media-upload.php?type=image&amp;TB_iframe=true');
				return false;
			  });
			  window.send_to_editor = function(html) {
				imgurl = $('img', html).attr('src');
				image_field.val(imgurl);
				tb_remove();
			  }
			});
		</script>
	<?php 
	}
}

class SH_post_categories_list extends WP_Widget
{
	/** constructor */
	function __construct()
	{
		parent::__construct( /* Base ID */ 'SH_post_categories_list', /* Name */ 'Dastak Post Categories', array( 'description' => 'Post categories list' ) );
	}

	/** @see WP_Widget::widget */
	function widget($args, $instance)
	{	
		extract( $args );
		$title = @apply_filters( 'widget_title', $instance['title'] );
		echo $before_widget;
		?>
        
        <?php
		
		$args = array( 'number' => $instance['num']);
		$categories = get_categories();
		
		$output ='<div class="s-category-widget">';
				
				$output .= $before_title.$title.$after_title;
				
				if($categories){
					
					$output	.='<ul>';
					foreach($categories as $category) { 
					
						$category_meta = get_option('_sh_category_settings'.$category->term_id);
						$meta = sh_set(sh_set($category_meta, 'sh_post_options'), '0');
						$output .='<li><a href="'.get_category_link( $category->term_id ).'" title="'. sprintf( __( "View all posts in %s", 'wp_dastak' ), $category->name ).'"><i class="fa '.str_replace( 'icon-', 'fa-', sh_set($meta, 'icon') ).'"></i>'.$category->name.'<span>('.$category->count.')</span></a></li>';
					}
					$output .='</ul>';
				}
		$output .='</div>'; 
		
		echo $output;
		
		?>
		
		<?php
		echo $after_widget;
	}
	
	
	/** @see WP_Widget::update */
	function update( $new_instance, $old_instance )
	{
		$instance = $old_instance;
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['num'] = strip_tags($new_instance['num']);

		return $instance;
	}

	/** @see WP_Widget::form */
	function form( $instance )
	{
		if ( $instance )
		{
			$title = esc_attr( $instance[ 'title' ] );
			$num = esc_attr($instance['num']);

		}
		else
		{
			$title = '';
			$num = '6';
		}

	?>    
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:', 'wp_dastak'); ?></label> 
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" />

            <label for="<?php echo $this->get_field_id('num'); ?>"><?php _e('Number of Categories:', 'wp_dastak'); ?></label> 
            <input class="widefat" id="<?php echo $this->get_field_id('num'); ?>" name="<?php echo $this->get_field_name('num'); ?>" type="text" value="<?php echo $num; ?>" />

		</p>
	<?php 
	}
}

class SH_galleries_list extends WP_Widget
{
	/** constructor */
	function __construct()
	{
		parent::__construct( /* Base ID */ 'SH_galleries_list', /* Name */ 'Dastak Galleries List', array( 'description' => 'Galleries list' ) );
	}

	/** @see WP_Widget::widget */
	function widget($args, $instance)
	{	
		extract( $args );
		$title = @apply_filters( 'widget_title', $instance['title'] );
		echo $before_widget;
		echo $before_title.$title.$after_title;
		?>
        
        <?php
		
		$output ='<div class="f-recent-projects">
					<div class="f-project-sec">	
						<div class="row">';
						$args = array('post_type'=>'sh_gallery', 'showposts'=>$instance['num']);
						$post_count = count(query_posts($args));
						$i=1;
						while(have_posts()): the_post();
							$output .='<div class="col-md-4"><a href="'.get_permalink().'">'.get_the_post_thumbnail(get_the_ID(), '370x370').'</a></div>';
						if($i%9==0 && $post_count !=$i) $output .='</div><div class="row">';
						$i++;
						endwhile;
						wp_reset_query();	
		$output .='</div>
					</div>
				</div>';
				
	    $output .='<script type="text/javascript">
					jQuery(document).ready(function($){
						$(".f-project-sec").owlCarousel({
							autoPlay :true,
							stopOnHover : true,
							goToFirstSpeed : 2000,
							slideSpeed:1500,
							singleItem : true,
							autoHeight : true,
							transitionStyle:"goDown",
							navigation:false
						});	
					});
				</script>';
		
		echo $output;
		
		?>
		
		<?php
		echo $after_widget;
	}
	
	
	/** @see WP_Widget::update */
	function update( $new_instance, $old_instance )
	{
		$instance = $old_instance;
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['num'] = strip_tags($new_instance['num']);

		return $instance;
	}

	/** @see WP_Widget::form */
	function form( $instance )
	{
		if ( $instance )
		{
			$title = esc_attr( $instance[ 'title' ] );
			$num = esc_attr($instance['num']);

		}
		else
		{
			$title = '';
			$num = '9';
		}

	?>    
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:', 'wp_dastak'); ?></label> 
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" />

            <label for="<?php echo $this->get_field_id('num'); ?>"><?php _e('Number of Galleries:', 'wp_dastak'); ?></label> 
            <input class="widefat" id="<?php echo $this->get_field_id('num'); ?>" name="<?php echo $this->get_field_name('num'); ?>" type="text" value="<?php echo $num; ?>" />

		</p>
	<?php 
	}
}