<?php
/** Include the TGM_Plugin_Activation class. */
require_once dirname( __FILE__ ) . '/class-tgm-plugin-activation.php';
add_action( 'tgmpa_register', 'my_theme_register_required_plugins' );

function my_theme_register_required_plugins()
{
    $plugins = array(
        array(
            'name' => 'Visual Composer',
            'slug' => 'js_composer',
            'source' => 'https://s3.amazonaws.com/webinane-themes-plugins/js_composer.zip',
            'required' => true,
            'version' => '6.0.3',
            'force_activation' => false,
            'force_deactivation' => false,
            'external_url' => 'http://wpbakery.com/',
            'file_path' => ABSPATH . 'wp-content/plugins/js_composer/js_composer.php'
        ),
        array(
            'name'             => esc_html__( 'Envato Market', 'actavista' ),
            'slug'             => 'envato-market',
            'source'           => 'https://envato.github.io/wp-envato-market/dist/envato-market.zip',
            'required'         => false,
            'recommended'      => true,
            'force_activation' => false,
        ),
        array(
            'name' => 'Layer Slider',
            'slug' => 'LayerSlider',
            'source' => 'https://s3.amazonaws.com/webinane-themes-plugins/LayerSlider.zip',
            'required' => true,
            'version' => '6.7.6',
            'force_activation' => false,
            'force_deactivation' => false,
            'external_url' => 'http://codecanyon.net/user/kreatura/',
            'file_path' => ABSPATH . 'wp-content/plugins/LayerSlider/layerslider.php'
        ),
        array(
            'name' => 'New Royal Slider',
            'slug' => 'new-royalslider',
            'source' => SH_ROOT . 'includes/library/tgm-plugin-activation/plugins/new-royalslider.zip',
            'required' => true,
            'version' => '3.3.2',
            'force_activation' => false,
            'force_deactivation' => false,
            'external_url' => 'http://dimsemenov.com',
            'file_path' => ABSPATH . 'wp-content/plugins/LayerSlider/newroyalslider.php'
        ),
        array(
            'name' => 'Woo Commerce WP',
            'slug' => 'woocommerce',
            'required' => true,
        ),
        array(
			'name' => esc_html__( 'MailChimp for WordPress', 'esperto' ),
			'slug' => 'mailchimp-for-wp',
		),	

    );

	// Change this to your theme text domain, used for internationalising strings
    $theme_text_domain = 'wp_dastak';

    $config = array(
		'domain'       		=> $theme_text_domain,         	// Text domain - likely want to be the same as your theme.
		'id'            => 'tgmpa',
		'default_path'  => '',
		'menu'          => 'tgmpa-install-plugins',
		'parent_slug'   => 'themes.php',
		'capability'    => 'edit_theme_options',
		'has_notices'   => true,
		'dismissable'   => true,
		'dismiss_msg'   => '',
		'is_automatic'  => false,
		'message'       => '',
		
	);

tgmpa($plugins, $config);
}