<?php
/** A function to fetch the categories from wordpress */

function sh_get_categories($arg = false, $by_slug = false, $multi = false) {



    global $wp_taxonomies;

    if (!empty($arg['taxonomy']) && !isset($wp_taxonomies[$arg['taxonomy']])) {

        register_taxonomy($arg['taxonomy'], 'sh_' . $arg['taxonomy']);

    }



    $categories = get_categories($arg);

    $cats = array();

    if ($multi)

        $cats[] = array('value' => 0, 'label' => __('All', 'wp_dastak'));

    else

        $cats[0] = __('All', 'wp_dastak');



    foreach ($categories as $category) {



        if ($by_slug)

            $cats[$category->slug] = $category->name;

        elseif ($multi)

            $cats[] = array('value' => $category->term_id, 'label' => $category->name);

        else

            $cats[$category->term_id] = $category->name;

    }



    return $cats;

}



if (!function_exists('sh_slug')) {



    function sh_slug($string) {

        $string = str_replace(' ', '-', $string); // Replaces all spaces with hyphens.

        return preg_replace('/[^A-Za-z0-9\-]/', '', $string); // Removes special chars.

    }



}



function sh_font_awesome($code = false) {

    $pattern = '/\.(fa-(?:\w+(?:-)?)+):before\s+{\s*content:\s*"(.+)";\s+}/';

    $subject = @file_get_contents(get_template_directory() . '/font-awesome/css/font-awesome.css');



    if (!$subject)

        return array();



    preg_match_all($pattern, $subject, $matches, PREG_SET_ORDER);



    $icons = array();



    foreach ($matches as $match) {

        $value = str_replace('icon-', '', $match[1]);

        if ($code)

            $icons[$match[1]] = stripslashes($match[2]);

        else

            $icons[$match[1]] = ucwords(str_replace(array('fa-', '-'), ' ', $value)); //$match[2];

    }



    return $icons;

}



function sh_get_sidebars($multi = false) {

    global $wp_registered_sidebars;



    $sidebars = !($wp_registered_sidebars) ? get_option('wp_registered_sidebars') : $wp_registered_sidebars;



    if ($multi)

        $data[] = array('value' => '', 'label' => 'No Sidebar');

    else

        $data = array('' => __('No Sidebar', 'wp_dastak'));

    foreach ((array) $sidebars as $sidebar) {

        if ($multi)

            $data[] = array('value' => sh_set($sidebar, 'id'), 'label' => sh_set($sidebar, 'name'));

        else

            $data[sh_set($sidebar, 'id')] = sh_set($sidebar, 'name');

    }



    return $data;

}



if (!function_exists('character_limiter')) {



    function character_limiter($str, $n = 500, $end_char = '&#8230;', $allowed_tags = false) {

        if ($allowed_tags)

            $str = strip_tags($str, $allowed_tags);

        if (strlen($str) < $n)

            return $str;

        $str = preg_replace("/\s+/", ' ', str_replace(array("\r\n", "\r", "\n"), ' ', $str));



        if (strlen($str) <= $n)

            return $str;



        $out = "";

        foreach (explode(' ', trim($str)) as $val) {

            $out .= $val . ' ';



            if (strlen($out) >= $n) {

                $out = trim($out);

                return ( strlen($out) == strlen($str)) ? $out : $out . $end_char;

            }

        }

    }



}



function sh_get_social_icons($class = '') {

    $options = get_option('wp_dastak' . '_theme_options');

    //printr($options);

    $social_class = ($class) ? 'class="' . $class . '"' : '';

    $output = '<ul ' . $social_class . '>';



    if (sh_set($options, 'social_icons') && is_array(sh_set($options, 'social_icons')))

        foreach (sh_set(sh_set($options, 'social_icons'), 'social_icons') as $social_icon) {



            if (isset($social_icon['tocopy']))

                continue;

            if (sh_set($social_icon, 'icon')) {

                $output .= '<li><a title="' . sh_set($social_icon, 'title') . '" href="' . sh_set($social_icon, 'link') . '"><i class="fa ' . sh_set($social_icon, 'icon') . '"></i></a></li>';

            }

        }



        $output .= '</ul>';



        return $output;

    }



    function sh_get_posts_array($post_type = 'post', $flip = false) {

        global $wpdb;



        $res = $wpdb->get_results("SELECT `ID`, `post_title` FROM `" . $wpdb->prefix . "posts` WHERE `post_type` = '$post_type' AND `post_status` = 'publish' ", ARRAY_A);



        $return = array();

        foreach ($res as $k => $r) {

        //echo '<pre>';print_r($res);

            if ($flip) {

                if (isset($return[sh_set($r, 'post_title')]))

                    $return[sh_set($r, 'post_title') . $k] = sh_set($r, 'ID');

                else

                    $return[sh_set($r, 'post_title')] = sh_set($r, 'ID');

            } else

            $return[sh_set($r, 'ID')] = sh_set($r, 'post_title') . ' - ' . sh_set($r, 'ID');

        }



        return $return;

    }



    function sh_get_royal_slider() {

        global $wpdb;

        $res = $wpdb->get_results("SELECT `id`, `name` FROM `" . $wpdb->prefix . "new_royalsliders`", ARRAY_A);



        $return = array();



        foreach ($res as $r) {

            $return[sh_set($r, 'id')] = sh_set($r, 'name');

            register_new_royalslider_files(sh_set($r, 'id'));

        }



        return $return;

    }



    function sh_get_posts_array2($post_type = 'post', $vp = false) {

        global $wpdb;



        $res = $wpdb->get_results("SELECT `ID`, `post_title` FROM `" . $wpdb->prefix . "posts` WHERE `post_type` = '$post_type' AND `post_status` = 'publish' ", ARRAY_A);

        $return = array();



        if ($vp)

            foreach ($res as $r)

                $return[] = array('value' => sh_set($r, 'ID'), 'label' => sh_set($r, 'post_title'));

            else

                foreach ($res as $r)

                    $return[sh_set($r, 'ID')] = sh_set($r, 'post_title');



                return $return;

            }



            function get_the_breadcrumb() {

                global $wp_query;

                $queried_object = get_queried_object();



                $breadcrumb = '';

                $delimiter = ' / ';

                $before = '';

                $after = '';



                if (!is_home() || $wp_query->is_posts_page) {



                    $breadcrumb .= '<a href="' . home_url() . '">' . __('Home', 'wp_dastak') . '</a>';



                    /** If category or single post */

                    if (is_category()) {

                        $cat_obj = $wp_query->get_queried_object();

                        $this_category = get_category($cat_obj->term_id);



                        if ($this_category->parent != 0) {

                            $parent_category = get_category($this_category->parent);

                            $breadcrumb .= get_category_parents($parent_category, TRUE, $delimiter);

                        }



                        $breadcrumb .= '<a href="' . get_category_link(get_query_var('cat')) . '">' . single_cat_title('', FALSE) . '</a>';

                    } elseif (is_tax()) {

                        $breadcrumb .= '<a href="' . get_term_link($queried_object) . '">' . $queried_object->name . '</a>';

                    } elseif (is_page()) /** If WP pages */ {



                        global $post;

                        if ($post->post_parent) {

                            $anc = get_post_ancestors($post->ID);

                            foreach ($anc as $ancestor) {

                                $breadcrumb .= '<a href="' . get_permalink($ancestor) . '">' . get_the_title($ancestor) . ' </a>';

                            }

                            $breadcrumb .= '<a href="javascript:void(0)">' . get_the_title($post->ID) . '</a>';

                        } else

                        $breadcrumb .= '<a href="javascript:void(0)">' . get_the_title() . '</a>';

                    }

                    elseif (is_singular()) {





                        if ($category = wp_get_object_terms(get_the_ID(), array('category', 'portfolio_category'))) {

                            if (!is_wp_error($category)) {

                                $breadcrumb .= '<a href="' . get_term_link(sh_set($category, '0')) . '">' . sh_set(sh_set($category, '0'), 'name') . '</a>';

                                $breadcrumb .= '<a href="javascript:void(0)">' . get_the_title() . '</a>';

                            }

                        } else {

                            $breadcrumb .= '<a href="javascript:void(0)">' . get_the_title() . '</a>';

                        }

                    } elseif (is_tag())

                    $breadcrumb .= '<a href="' . get_term_link($queried_object) . '">' . single_tag_title('', FALSE) . '</a>'; /*             * If tag template */

                    elseif (is_day())

                        $breadcrumb .= '<a href="javascript:void(0)">' . __('Archive for ', 'wp_dastak') . get_the_time('F jS, Y') . '</a>';/** If daily Archives */

                    elseif (is_month())

                        $breadcrumb .= '<a href="' . get_month_link(get_the_time('Y'), get_the_time('m')) . '">' . __('Archive for ', 'wp_dastak') . get_the_time('F, Y') . '</a>';/** If montly Archives */

                    elseif (is_year())

                        $breadcrumb .= '<a href="' . get_year_link(get_the_time('Y')) . '">' . __('Archive for ', 'wp_dastak') . get_the_time('Y') . '</a>';/** If year Archives */

                    elseif (is_author())

                        $breadcrumb .= '<a href="' . esc_url(get_author_posts_url(get_the_author_meta("ID"))) . '">' . __('Archive for ', 'wp_dastak') . get_the_author() . '</a>';/** If author Archives */

                    elseif (is_search())

                        $breadcrumb .= '<a href="javascript:void(0)">' . __('Search Results for ', 'wp_dastak') . get_search_query() . '</a>';/** if search template */

                    elseif (is_404())

                        $breadcrumb .= '<a href="javascript:void(0)">' . __('404 - Not Found', 'wp_dastak') . '</a>';/** if search template */

                    elseif (is_post_type_archive('product')) {



                        $shop_page_id = wc_get_page_id('shop');

                        if (get_option('page_on_front') !== $shop_page_id) {

                            $shop_page = get_post($shop_page_id);



                            $_name = wc_get_page_id('shop') ? get_the_title(wc_get_page_id('shop')) : '';



                            if (!$_name) {

                                $product_post_type = get_post_type_object('product');

                                $_name = $product_post_type->labels->singular_name;

                            }



                            if (is_search()) {



                                $breadcrumb .= $before . '<a href="' . get_post_type_archive_link('product') . '">' . $_name . '</a>' . $delimiter . __('Search results for &ldquo;', 'wp_dastak') . get_search_query() . '&rdquo;' . $after;

                            } elseif (is_paged()) {



                                $breadcrumb .= $before . '<a href="' . get_post_type_archive_link('product') . '">' . $_name . '</a>' . $after;

                            } else {



                                $breadcrumb .= $before . '<a href="javascript:void(0);">' . $_name . '</a>' . $after;

                            }

                        }

                    } elseif ($wp_query->is_posts_page) {

                        $query_obj = $wp_query->get_queried_object();

                        $breadcrumb .= '<a href="' . $query_obj->guid . '">' . $query_obj->post_title . '</a>';

                    } else

                    $breadcrumb .= '<a href="' . get_permalink() . '">' . get_the_title() . '</a>';/** Default value */

                }



                return '<div class="breadcrumbs">' . $breadcrumb . '</div>';

            }



            function sh_register_user($data) {

    //printr($data);

                $user_name = sh_set($data, 'user_login');

                $user_email = sh_set($data, 'user_email');

                $user_pass = sh_set($data, 'user_password');

                $policy = sh_set($data, 'policy_agreed');



                $user_id = username_exists($user_name);

                $message = '<div class="alert-error" style="margin-bottom:10px;padding:10px"><h5>' . __('You must agreed the policy', 'wp_dastak') . '</h5></div>';

                ;

                if (!$policy)

                    $message = '';

                if (!$user_id && email_exists($user_email) == false) {



                    if ($policy) {



                        $random_password = ( $user_pass ) ? $user_pass : wp_generate_password($length = 12, $include_standard_special_chars = false);

                        $user_id = wp_create_user($user_name, $random_password, $user_email);

                        if (is_wp_error($user_id) && is_array($user_id->get_error_messages())) {

                            foreach ($user_id->get_error_messages() as $message)

                                $message .= '<div class="alert-error" style="margin-bottom:10px;padding:10px"><h5>' . $message . '</h5></div>';

                        } else

                        $message = '<div class="alert-success" style="margin-bottom:10px;padding:10px"><h5>' . __('Registration Successful - An email is sent', 'wp_dastak') . '</h5></div>';

                    }

                } else {

                    $message .= '<div class="alert-error" style="margin-bottom:10px;padding:10px"><h5>' . __('Username or email already exists.  Password inherited.', 'wp_dastak') . '</h5></div>';

                }



                return $message;

            }



            function sh_list_comments($comment, $args, $depth) {

                $GLOBALS['comment'] = $comment;

    //if(get_comment_type() == 'comment'):

                ?>



                <li>

                    <div class="comment" id="comment-<?php echo comment_ID(); ?>">

                        <div class="comment-avatar">

                            <span><?php echo get_avatar($comment, 70); ?></span>

                            <?php comment_reply_link(array_merge($args, array('depth' => $depth, 'max_depth' => $args['max_depth']))) ?>

                        </div>

                        <div class="user-comment <?php echo ($depth > 1) ? 'reply' : '' ?>">



                            <a href=""><?php echo get_comment_author_link(); ?></a>

                            <a href="javascript:void(0);"><i><?php echo get_comment_date(); ?></i></a>

                            <?php comment_text();/** print our comment text */ ?> 



                        </div>  

                    </div>



                    <?php

        //endif;

                }



    /**

     * returns the formatted form of the comments

     *

     * @param	array	$args		an array of arguments to be filtered

     * @param	int		$post_id	if form is called within the loop then post_id is optional

     *

     * @return	string	Return the comment form

     */

    function sh_comment_form($args = array(), $post_id = null, $review = false) {

        if (null === $post_id)

            $post_id = get_the_ID();

        else

            $id = $post_id;



        $commenter = wp_get_current_commenter();

        $user = wp_get_current_user();

        $user_identity = $user->exists() ? $user->display_name : '';



        $args = wp_parse_args($args);

        if (!isset($args['format']))

            $args['format'] = current_theme_supports('html5', 'comment-form') ? 'html5' : 'xhtml';



        $req = get_option('require_name_email');

        $aria_req = ( $req ? " aria-required='true'" : '' );

        $html5 = 'html5' === $args['format'];

        $fields = array(

            'author' => '<div class="col-md-4"><input id="author" placeholder="' . __('Your Name', 'wp_dastak') . '" class="input-style" name="author" type="text" value="' . esc_attr($commenter['comment_author']) . '" size="30"' . $aria_req . ' /></div>',

            'email' => '<div class="col-md-4"><input id="email" placeholder="' . __('Your Email', 'wp_dastak') . '" class="input-style" name="email" ' . ( $html5 ? 'type="email"' : 'type="text"' ) . ' value="' . esc_attr($commenter['comment_author_email']) . '" size="30"' . $aria_req . ' /></div>',

            'url' => '<div class="col-md-4"><input id="url" placeholder="' . __('Website', 'wp_dastak') . '" class="input-style" name="url" ' . ( $html5 ? 'type="url"' : 'type="text"' ) . ' value="' . esc_attr($commenter['comment_author_url']) . '" size="30" /></div>',

        );



        $required_text = sprintf(' ' . __('Required fields are marked %s', 'wp_dastak'), '<span class="required">*</span>');



        /**

         * Filter the default comment form fields.

         *

         * @since 3.0.0

         *

         * @param array $fields The default comment fields.

         */

        $fields = apply_filters('comment_form_default_fields', $fields);

        $defaults = array(

            'fields' => $fields,

            'comment_field' => '<textarea id="comment" placeholder="' . __('Your Comment', 'wp_dastak') . '" class="input-style" name="comment" cols="45" rows="8" aria-required="true"></textarea></p>',

            'must_log_in' => '<p class="must-log-in">' . sprintf(__('You must be <a href="%s">logged in</a> to post a comment.', 'wp_dastak'), wp_login_url(apply_filters('the_permalink', get_permalink($post_id)))) . '</p>',

            'logged_in_as' => '<p class="logged-in-as">' . sprintf(__('Logged in as <a href="%1$s">%2$s</a>. <a href="%3$s" title="Log out of this account">Log out?</a>', 'wp_dastak'), get_edit_user_link(), $user_identity, wp_logout_url(apply_filters('the_permalink', get_permalink($post_id)))) . '</p>',

            'comment_notes_before' => '<p class="comment-notes">' . __('Hey, so you decided to leave a comment! That�s great. Just fill in the required fields and hit submit. Note that your comment will need to be reviewed before it�s published', 'wp_dastak') . ( $req ? $required_text : '' ) . '</p>',

            'comment_notes_after' => '<p class="form-allowed-tags">' . sprintf(__('You may use these <abbr title="HyperText Markup Language">HTML</abbr> tags and attributes: %s', 'wp_dastak'), ' <code>' . allowed_tags() . '</code>') . '</p>',

            'id_form' => 'commentform',

            'id_submit' => 'submit',

            'title_reply' => __('Leave Reply', 'wp_dastak'),

            'title_reply_to' => __('Leave a Reply to %s', 'wp_dastak'),

            'cancel_reply_link' => __('Cancel reply', 'wp_dastak'),

            'label_submit' => __('Submit', 'wp_dastak'),

            'format' => 'xhtml',

        );



        /**

         * Filter the comment form default arguments.

         *

         * Use 'comment_form_default_fields' to filter the comment fields.

         *

         * @since 3.0.0

         *

         * @param array $defaults The default comment form arguments.

         */

        $args = wp_parse_args($args, apply_filters('comment_form_defaults', $defaults));

        ?>

        <?php if (comments_open($post_id)) : ?>

            <?php

            /**

             * Fires before the comment form.

             *

             * @since 3.0.0

             */

            do_action('comment_form_before');

            ?>

            <div id="respond" class="leave-reply">

                <div class="heading2">

                    <h2><?php comment_form_title($args['title_reply'], $args['title_reply_to']); ?> <small><?php cancel_comment_reply_link($args['cancel_reply_link']); ?></small></h2>

                    <span><i></i><i></i><i></i><i></i><i></i><i></i><i></i><i></i><i></i><i></i></span>

                </div>

                <?php if (get_option('comment_registration') && !is_user_logged_in()) : ?>

                    <?php echo $args['must_log_in']; ?>

                    <?php

                    /**

                     * Fires after the HTML-formatted 'must log in after' message in the comment form.

                     *

                     * @since 3.0.0

                     */

                    do_action('comment_form_must_log_in_after');

                    ?>

                <?php else : ?>

                    <form action="<?php echo site_url('/wp-comments-post.php'); ?>" method="post" id="<?php echo esc_attr($args['id_form']); ?>" class="comment-form"<?php echo $html5 ? ' novalidate' : ''; ?>>

                        <?php

                        /**

                         * Fires at the top of the comment form, inside the <form> tag.

                         *

                         * @since 3.0.0

                         */

                        do_action('comment_form_top');

                        ?>

                        <div class="row">

                            <?php if (is_user_logged_in()) : ?>

                                <?php

                                /**

                                 * Filter the 'logged in' message for the comment form for display.

                                 *

                                 * @since 3.0.0

                                 *

                                 * @param string $args['logged_in_as'] The logged-in-as HTML-formatted message.

                                 * @param array  $commenter            An array containing the comment author's username, email, and URL.

                                 * @param string $user_identity        If the commenter is a registered user, the display name, blank otherwise.

                                 */

                                echo apply_filters('comment_form_logged_in', $args['logged_in_as'], $commenter, $user_identity);

                                ?>

                                <?php

                                /**

                                 * Fires after the is_user_logged_in() check in the comment form.

                                 *

                                 * @since 3.0.0

                                 *

                                 * @param array  $commenter     An array containing the comment author's username, email, and URL.

                                 * @param string $user_identity If the commenter is a registered user, the display name, blank otherwise.

                                 */

                                do_action('comment_form_logged_in_after', $commenter, $user_identity);

                                ?>

                            <?php else : ?>

                                <?php echo $args['comment_notes_before']; ?>



                                <?php

                                /**

                                 * Fires before the comment fields in the comment form.

                                 *

                                 * @since 3.0.0

                                 */

                                do_action('comment_form_before_fields');

                                foreach ((array) $args['fields'] as $name => $field) {

                                    /**

                                     * Filter a comment form field for display.

                                     *

                                     * The dynamic portion of the filter hook, $name, refers to the name

                                     * of the comment form field. Such as 'author', 'email', or 'url'.

                                     *

                                     * @since 3.0.0

                                     *

                                     * @param string $field The HTML-formatted output of the comment form field.

                                     */

                                    echo apply_filters("comment_form_field_{$name}", $field) . "\n";

                                }

                                /**

                                 * Fires after the comment fields in the comment form.

                                 *

                                 * @since 3.0.0

                                 */

                                do_action('comment_form_after_fields');

                                ?>



                            <?php endif; ?>

                            <div class="col-md-12">

                                <?php

                                /**

                                 * Filter the content of the comment textarea field for display.

                                 *

                                 * @since 3.0.0

                                 *

                                 * @param string $args['comment_field'] The content of the comment textarea field.

                                 */

                                echo apply_filters('comment_form_field_comment', $args['comment_field']);

                                ?>

                                <?php echo $args['comment_notes_after']; ?>



                                <input name="submit" type="submit" class="submit" id="<?php echo esc_attr($args['id_submit']); ?>" value="<?php echo esc_attr($args['label_submit']); ?>" />

                                <?php comment_id_fields($post_id); ?>



                            </div>

                            <?php

                            /**

                             * Fires at the bottom of the comment form, inside the closing </form> tag.

                             *

                             * @since 1.5.2

                             *

                             * @param int $post_id The post ID.

                             */

                            do_action('comment_form', $post_id);

                            ?>

                        </div>

                    </form>

                <?php endif; ?>

            </div><!-- #respond -->

            <?php

            /**

             * Fires after the comment form.

             *

             * @since 3.0.0

             */

            do_action('comment_form_after');

        else :

            /**

             * Fires after the comment form if comments are closed.

             *

             * @since 3.0.0

             */

            do_action('comment_form_comments_closed');

        endif;

    }



    function sh_team_listing($query) {



        while ($query->have_posts()): $query->the_post();

            ?>

            <div class="span3">

                <div class="team-member vcard"> 

                    <?php if (has_post_thumbnail()) the_post_thumbnail(array(500, 300), array('class' => 'photo')); ?>



                    <h4 class="fn"><?php the_title(); ?></h4>

                    <ul class="social-links">

                        <?php $settings = get_post_meta(get_the_ID(), '_bistro_bistro_team_settings', true); ?>

                        <?php if (sh_set($settings, 'twitter')): ?>

                            <li><a href="<?php echo sh_set($settings, 'twitter'); ?>" class="url"><i class="icon-fixed-width icon-twitter"></i><span class="visuallyhidden">Twitter</span></a></li>

                        <?php endif; ?>

                        <?php if (sh_set($settings, 'facebook')): ?>

                            <li><a href="<?php echo sh_set($settings, 'facebook'); ?>" class="url"><i class="icon-fixed-width icon-facebook"></i><span class="visuallyhidden">Facebook</span></a></li>

                        <?php endif; ?>

                        <?php if (sh_set($settings, 'google_plus')): ?>

                            <li><a href="<?php echo sh_set($settings, 'google_plus'); ?>" class="url"><i class="icon-fixed-width icon-google-plus"></i><span class="visuallyhidden">Google Plus</span></a></li>

                        <?php endif; ?>

                    </ul>



                    <?php if (sh_set($settings, 'designation')): ?>

                        <span class="title">Founder</span>

                    <?php endif; ?>

                    <?php echo character_limiter(get_the_excerpt(), 150); ?>

                </div>

            </div>

            <!-- .span3 -->

            <?php

        endwhile;

    }



    function sh_contact_form_submit() {

        if (!count($_POST))

            return;





        _load_class('validation', 'helpers', true);

        $t = &$GLOBALS['_sh_base']; //printr($t);

        $settings = get_option('wp_bistro');



        /** set validation rules for contact form */

        $t->validation->set_rules('contact_name', '<strong>' . __('Name', 'wp_dastak') . '</strong>', 'required|min_length[4]|max_lenth[30]');

        $t->validation->set_rules('contact_email', '<strong>' . __('Email', 'wp_dastak') . '</strong>', 'required|valid_email');

        $t->validation->set_rules('contact_message', '<strong>' . __('Message', 'wp_dastak') . '</strong>', 'required|min_length[5]');

        if (sh_set($settings, 'captcha_status') == 'on') {

            if (sh_set($_POST, 'contact_captcha') !== sh_set($_SESSION, 'captcha')) {

                $t->validation->_error_array['captcha'] = __('Invalid captcha entered, please try again.', 'wp_dastak');

            }

        }



        $messages = '';



        if ($t->validation->run() !== FALSE && empty($t->validation->_error_array)) {



            $name = $t->validation->post('contact_name');

            $email = $t->validation->post('contact_email');

            $message = $t->validation->post('contact_message');

            $contact_to = ( sh_set($settings, 'contact_email') ) ? sh_set($settings, 'contact_email') : get_option('admin_email');



            $headers = 'From: ' . $name . ' <' . $email . '>' . "\r\n";

            wp_mail($contact_to, __('Contact Us Message', 'wp_dastak'), $message, $headers);



            $message = sh_set($settings, 'success_message') ? $settings['success_message'] : sprintf(__('Thank you <strong>%s</strong> for using our contact form! Your email was successfully sent and we will be in touch with you soon.', 'wp_dastak'), $name);



            $messages = '<div class="alert alert-success">

            <p class="title">' . __('SUCCESS! ', 'wp_dastak') . $message . '</p>

            </div>';

        } else {

            if (is_array($t->validation->_error_array)) {

                foreach ($t->validation->_error_array as $msg) {

                    $messages .= '<div class="alert alert-error">

                    <p class="title">' . __('Error! ', 'wp_dastak') . $msg . '</p>

                    </div>';

                }

            }

        }



        return $messages;

    }



    function sh_blog_excerpt_more($more) {

        return '';

    }



    add_filter('excerpt_more', 'sh_blog_excerpt_more');



    function _the_pagination1($args = array(), $echo = 1) {



        global $wp_query;



        $settings = get_option('wp_dastak' . '_theme_options');



        $default = array('base' => str_replace(99999, '%#%', esc_url(get_pagenum_link(99999))), 'format' => '?paged=%#%', 'current' => max(1, get_query_var('paged')),

            'total' => $wp_query->max_num_pages, 'next_text' => 'Next', 'prev_text' => 'Previous', 'type' => 'list', 'prev_next' => false);



        $args = wp_parse_args($args, $default);



        $pagination = '<div class="c-pagination remove-gap fadein">

        <div class="dark">

        <div class="fixed-img sec-bg9"></div>';







        $pagination .= '<div class="pagination">' . paginate_links($args) . '</div>';



        $pagination .= '</div></div>';







        if (paginate_links(array_merge(array('type' => 'array'), $args))) {

            if ($echo)

                echo $pagination;

            return $pagination;

        }

    }



    function _the_pagination($pages = '', $range = 1) {

        $settings = get_option('wp_dastak' . '_theme_options');

        $showitems = ($range * 2) + 1;



        global $paged;

        if (empty($paged))

            $paged = 1;



        if ($pages == '') {

            global $wp_query;

            $pages = $wp_query->max_num_pages;

            if (!$pages) {

                $pages = 1;

            }

        }



        if (1 != $pages) {

            $background = (sh_set($settings, 'pagination_background')) ? 'style="background-image:url(' . sh_set($settings, 'pagination_background') . ');"' : '';

            echo '<div class="c-pagination remove-gap fadein" ' . $background . '>

            <div class="dark">

            <div class="fixed-img sec-bg9"></div>';

            echo "<div class='pagination'>";

            if ($paged > 2 && $paged > $range + 1 && $showitems < $pages)

                echo "<a id='prev' href='" . get_pagenum_link(1) . "'><i class='fa fa-angle-left'></i>" . __('Previous', 'wp_dastak') . "</a>";

            if ($paged > 1 && $showitems < $pages)

                echo "<a id='prev' href='" . get_pagenum_link($paged - 1) . "'><i class='fa fa-angle-left'></i>" . __('Previous', 'wp_dastak') . "</a>";

            echo '<ul>';

            for ($i = 1; $i <= $pages; $i++) {

                if (1 != $pages && (!($i >= $paged + $range + 1 || $i <= $paged - $range - 1) || $pages <= $showitems )) {

                    echo ($paged == $i) ? "<li><a href='javascript:voic(0)' class='active'>" . $i . "</a></li>" : "<li><a href='" . get_pagenum_link($i) . "' class='inactive' >" . $i . "</a></li>";

                }

            }

            echo '</ul>';



            if ($paged < $pages && $showitems < $pages)

                echo "<a id='next' href='" . get_pagenum_link($paged + 1) . "'>" . __('Next', 'wp_dastak') . "<i class='fa fa-angle-right'></i></a>";



            echo "</div>";

            echo '</div></div>';

        }

    }



    function sh_get_post_format_output($settings = array()) {

        global $post;



        $theme_options = get_option('wp_dastak' . '_theme_options');



        $size = (sh_set($theme_options, 'blog_style') == 'style1') ? '370x337' : '870x347';



        if (is_single())

            $size = '870x347';



        if (!$settings)

            return;



        $format = get_post_format();



        $output = '';



        switch ($format) {

            case 'standard':

            case 'image':

            $output = '<div>' . get_the_post_thumbnail(get_the_id(), $size) . '</div>';

            break;

            case 'gallery':

            $attachments = get_posts('post_type=attachment&post_parent=' . get_the_id());

            if ($attachments) {

                $output = '<div class="tp-banner-container">

                <div class="tp-banner" >

                <ul>';

                foreach ($attachments as $att) {

                    $output .= '

                    <li data-transition="3dcurtain-vertical" data-slotamount="7" data-masterspeed="500">

                    ' . wp_get_attachment_image($att->ID, $size) . '

                    </li>';

                }

                $output .= '</ul></div></div>';

            }

            break;

            case 'video':

            $output = '<div>' . sh_set($settings, 'video') . '</div>';

            break;

            case 'audio':

            $output = '<div>' . sh_set($settings, 'audio') . '</div>';

            break;



            default:

            $output = '<div>' . get_the_post_thumbnail(get_the_id(), $size) . '</div>';

            break;

        }



        return $output;

    }



    function sh_awards_post_format_output($settings = array()) {

        global $post;

        $video = sh_get_post_meta_value($post->ID, 'video');

        $audio = sh_get_post_meta_value($post->ID, 'audio');

        $format = get_post_format();



        $output = '';



        switch ($format) {

            case 'standard':



            $output = get_the_post_thumbnail(get_the_id(), '570x350');



            case 'image':

            $attachments = get_posts('post_type=attachment&post_parent=' . get_the_id());

            if ($attachments) {



                foreach ($attachments as $att) {

                    $output .= '<span>' . wp_get_attachment_image($att->ID, '370x370') . '</span>';

                }

            }



            break;

            case 'gallery':



            $attachments = get_posts('post_type=attachment&post_parent=' . get_the_id());

            if ($attachments) {

                $output = '<ul id="timeline-slide1">';

                foreach ($attachments as $att) {

                    $output .= '<li>' . wp_get_attachment_image($att->ID, '570x350') . '</li>';

                }

                $output .= '</ul>';

            }

            break;

            case 'video':

            $output = $video;

            break;

            case 'audio':

            $output = $audio;

            break;



            default:

            $output = get_the_post_thumbnail(get_the_id(), '570x350');

            break;

        }



        return $output;

    }



    function sh_theme_color_scheme($cookie = false) {



        $settings = get_option('wp_dastak' . '_theme_options');

        $background_style = '';

        if (sh_set($settings, 'boxed_layout_status') && sh_set($settings, 'background_type') == 'image') {

            $background_style .='body{';

            $background_style .= 'background-image:url(' . sh_set($settings, 'background_image') . ') !important;';

            $background_style .= 'background-repeat:' . sh_set($settings, 'background_repeat') . ' !important;';



            $background_style .= 'background-attachment:' . sh_set($settings, 'background_attachment') . '  !important;';

            $background_style .= '}';

        }

        if (sh_set($settings, 'boxed_layout_status') && sh_set($settings, 'background_type') == 'pattern') {

            $background_style .='body{';

            $background_style .= (sh_set($settings, 'background_color')) ? 'background-color:' . sh_set($settings, 'background_color') . ' !important;' : '';

            $background_style .= 'background-image:url(' . get_template_directory_uri() . '/images/patterns/' . sh_set($settings, 'patterns') . '.png);';

            $background_style .= '}';

        }

        if ($background_style) {

            echo '<style type="text/css">' . $background_style . '</style>';

        }



        if (sh_set($settings, 'color_selection') == 'default') {

            $default_color_scheme = sh_set($settings, 'default_color_scheme');

            echo '<link rel="stylesheet" type="text/css" href="' . get_template_directory_uri() . '/css/' . $default_color_scheme . '.css" />';

        } else {

            $styles = sh_set($settings, 'custom_color_scheme');

            $_COOKIE['sh_color_scheme'] = isset($_COOKIE['sh_color_scheme']) ? $_COOKIE['sh_color_scheme'] : $styles;



            $custom_style = ( $cookie && isset($_COOKIE['sh_color_scheme']) ) ? $_COOKIE['sh_color_scheme'] : $styles;



            $color_file = file_get_contents(get_template_directory() . '/css/color.css');

            //printr($color_file);



            $content = sh_set($color_file, 'body');



            if ($custom_style) {



                $replace = str_replace('#4591ed', $custom_style, $color_file);



                $replace = ( $custom_style ) ? $replace : $content;

            } else

            $replace = $content;



            echo "\n" . '<style title="sh_color_scheme">' . $replace . '</style>';

        }

    }



    function sh_get_font_settings($FontSettings = array(), $StyleBefore = '', $StyleAfter = '') {

        $i = 1;

        $settings = get_option('wp_dastak' . '_theme_options');



        $Style = '';

        foreach ($FontSettings as $k => $v) {





            if ($v == 'font-size') {

                $Style .= ( sh_set($settings, $k) ) ? $v . ':' . sh_set($settings, $k) . 'px !important;' : '';

            } elseif ($v == 'font-family') {

                $Style .= ( sh_set($settings, $k) ) ? $v . ':' . sh_set($settings, $k) . ' !important;' : '';

            } elseif ($v == 'color') {

                $Style .= ( sh_set($settings, $k) ) ? $v . ':' . sh_set($settings, $k) . ' !important;' : '';

            } else {

                $Style .= ( sh_set($settings, $k) ) ? $v . ':' . sh_set($settings, $k) . ' !important;' : '';

            }

            $i++;

        }

        return ( !empty( $Style ) ) ? $StyleBefore.$Style.$StyleAfter: '';

    }



    function sh_posts_by_year() {

        $years = array();



        $posts = get_posts(array(

            'numberposts' => -1,

            'orderby' => 'post_date',

            'order' => 'ASC',

            'post_type' => 'post',

            'post_status' => 'publish'

        ));



        foreach ($posts as $post) {

            $years[date('Y', strtotime($post->post_date))][] = $post;

        }



        krsort($years);



        return $years;

    }



    function sh_register_dynamic_sidebar() {

        $theme_options = get_option('wp_dastak' . '_theme_options');

        $sidebars = sh_set(sh_set($theme_options, 'dynamic_sidebar'), 'dynamic_sidebar');



        if ($sidebars && is_array($sidebars)) {

            foreach ($sidebars as $sidebar) {



                if (isset($sidebar['tocopy']))

                    continue;



                register_sidebar(array(

                    'name' => $sidebar['sidebar_name'],

                    'id' => sh_slug($sidebar['sidebar_name']),

                    'before_widget' => '<div id="%1$s" class="widget %2$s">',

                    'after_widget' => "</div>",

                    'before_title' => '<h4 class="title"><span>',

                    'after_title' => '</span></h4>',

                ));

            }

        }

    }



    function get_gravatar_url($email) {



        $hash = md5(strtolower(trim($email)));

        return 'http://gravatar.com/avatar/' . $hash;

    }



    function sh_apply_color_scheme($cookie = false) {

        $dir = get_template_directory();

        $styles = sh_set(get_option('wp_dastak' . '_theme_options'), 'color_scheme');

        $_COOKIE['fw_color_scheme'] = isset($_COOKIE['fw_color_scheme']) ? $_COOKIE['fw_color_scheme'] : $styles;



        $custom_style = ( $cookie && isset($_COOKIE['fw_color_scheme']) ) ? $_COOKIE['fw_color_scheme'] : $styles;





        ob_start();

        include ($dir . '/css/color.css');

        $content = ob_get_contents();

        ob_end_clean();



        if ($custom_style) {



            $replace = str_replace('#389ED1', $custom_style, $content);



            $replace = ( $custom_style ) ? $replace : $content;

        } else

        $replace = $content;



        echo "\n" . '<style title="fw_color_scheme">' . $replace . '</style>';

    }



    function page_template($tpl) {

        $page = get_pages(array('meta_key' => '_wp_page_template', 'meta_value' => $tpl));

        if ($page)

            return current((array) $page);

        else

            return false;

    }



    function sh_get_meta_value($page_id, $key) {

        $meta_settings = get_post_meta($page_id, 'sh_page_meta', true);

        $meta_values = sh_set(sh_set(sh_set($meta_settings, 'sh_post_options'), 0), $key);

        return $meta_values;

    }



    function sh_get_post_meta_value($post_id, $key) {

        $meta_settings = get_post_meta($post_id, 'sh_post_meta', true);

        $meta_values = sh_set(sh_set(sh_set($meta_settings, 'sh_post_options'), 0), $key);

        return $meta_values;

    }



    function sh_get_page_title() {

        global $wp_query;

        $options = get_option('wp_dastak' . '_theme_options');

        if ($wp_query->is_posts_page || is_home()) {

            $query_obj = $wp_query->get_queried_object();

            $title_array = explode(' ', sh_set($options, 'blog_page_title'));

        } else {

            $title = get_the_title();

            $title_array = explode(' ', $title, 2);

        }

        ?>

        <h2><i><?php echo sh_set($title_array, '0'); ?></i><?php echo sh_set($title_array, '1'); ?></h2>

        <!--<span><i></i><i></i><i></i><i></i><i></i><i></i><i></i><i></i><i></i><i></i></span>-->

        <?php

    }



    function sh_get_title($title, $title_bar = false, $tag = true) {

        $title_array = explode(' ', $title, 2);

        if ($tag)

            $output = '<h2><i>' . sh_set($title_array, '0') . '</i> ' . sh_set($title_array, '1') . '</h2>';

        else

            $output = '<i>' . sh_set($title_array, '0') . '</i> ' . sh_set($title_array, '1');

        $output .= ($title_bar) ? '<span><i></i><i></i><i></i><i></i><i></i><i></i><i></i><i></i><i></i><i></i></span>' : '';



        return $output;

    }



    function sh_get_title2($title, $title_bar = false, $tag = true) {

        $title_array = explode(' ', $title, 2);

        if ($tag)

            $output = '<h2>' . sh_set($title_array, '0') . ' <i>' . sh_set($title_array, '1') . '</i></h2>';

        else

            $output = sh_set($title_array, '0') . ' <i>' . sh_set($title_array, '1') . '</i>';

        $output .= ($title_bar) ? '<span><i></i><i></i><i></i><i></i><i></i><i></i><i></i><i></i><i></i><i></i></span>' : '';



        return $output;

    }



    function sh_get_section_title($title, $sub_title = '', $style = 1) {



        $output = '';

        if ($style == 1 || $style == 2 || $style == 3 || $style == 4) {



            $output .='<div class="heading' . $style . '">

            <h2>' . $title . '</h2>

            </div>';

        } elseif ($style == 5 || $style == 6) {

            $output .='<div class="heading' . $style . '">

            <h2>' . $title . '</h2>

            <span>' . $sub_title . '</span>

            </div>';

        } elseif ($style == 7) {

            $output .='<h3 class="mini-heading">' . $title . '</h3>';

        } elseif ($style == 8) {

            $output .= '<h4 class="title">' . $title . '</h4>';

        }



        return $output;

    }



    function sh_comments_count($post_id) {



        $comments_count = wp_count_comments($post_id);

        return $comments_count->approved;

    }



    function sh_post_social_icons() {

        ?>

        <ul class="post-social">

            <li><a title="<?php _e('Facebook', 'wp_dastak'); ?>" href="http://www.facebook.com/sharer/sharer.php?u=<?php echo urlencode(get_permalink()); ?>"><i class="fa fa-facebook"></i></a></li>

            <li><a title="<?php _e('Google Plus', 'wp_dastak'); ?>" href="https://plusone.google.com/_/+1/confirm?hl=en&amp;url=<?php echo urlencode(get_permalink()); ?>"><i class="fa fa-google-plus"></i></a></li>

            <li><a title="<?php _e('Twitter', 'wp_dastak'); ?>" href="http://twitter.com/share?text=<?php echo strip_tags(get_the_excerpt()); ?>&amp;url=<?php echo urlencode(get_permalink()); ?>"><i class="fa fa-twitter"></i></a></li>

            <li><a title="<?php _e('Pinterest', 'wp_dastak'); ?>" href='javascript:void((function()%7Bvar%20e=document.createElement(&apos;script&apos;);e.setAttribute(&apos;type&apos;,&apos;text/javascript&apos;);e.setAttribute(&apos;charset&apos;,&apos;UTF-8&apos;);e.setAttribute(&apos;src&apos;,&apos;http://assets.pinterest.com/js/pinmarklet.js?r=&apos;+Math.random()*99999999);document.body.appendChild(e)%7D)());'><i class="fa fa-pinterest"></i></a></li>

        </ul>



        <?php

    }



    function sh_get_post_terms($post_id, $taxonomy, $args = array()) {

        $terms_list = wp_get_post_terms($post_id, $taxonomy, $args);

        $terms = '';

        if(!empty($terms_list)){

            foreach ($terms_list as $pterm) {

                $terms_class[$pterm->term_id] = '<a href="' . get_term_link($pterm) . '">' . $pterm->name . '</a>';

            }

            $terms = implode(', ', $terms_class);

        }

        return $terms;

    }



    function sh_get_post_categories($post_id, $taxonomy, $args = array()) {

        $terms_list = wp_get_post_terms($post_id, $taxonomy, $args);

        $terms_links = '';

        foreach ($terms_list as $pterm) {

            $terms_links .= '<li><a href="' . get_term_link($pterm) . '"><i class="fa fa-files-o"></i>' . $pterm->name . '</a></li>';

        }

        //$terms = implode(', ', $terms_class);

        return $terms_links;

    }



    function SH_Twitter($args = array()) {

        $selector = sh_set($args, 'selector');

        $temp = sh_set($args, 'template', 'blockquote');

        $count = sh_set($args, 'count', 3);

        $screen = sh_set($args, 'screen_name', 'Wordpress');

        $options = array('template' => $temp, 'count' => $count, 'screen_name' => $screen);

        ?>





        <script type="text/javascript">

            jQuery(document).ready(function ($) {

                $('<?php echo $selector; ?>').tweets(<?php echo json_encode($options); ?>);

            });

        </script>





        <?php

    }



    function SH_Twitter_ajax_callback() {

        $settings = get_option('wp_dastak' . '_theme_options');

        include('codebird.php');

        Codebird::setConsumerKey(sh_set($settings, 'api'), sh_set($settings, 'api_secret'));

        $cb = Codebird::getInstance();



        $cb->setToken(sh_set($settings, 'token'), sh_set($settings, 'token_secret'));



        $params = array(

            'screen_name' => sh_set($_POST, 'screen_name'),

            'count' => sh_set($_POST, 'count'),

            'exclude_replies' => 0,

            'include_rts' => 0,

            'include_entities' => 0,

            'trim_user' => false,

            'contributor_details' => false

        );



        $reply = $cb->statuses_userTimeline($params);

        unset($reply->httpstatus);

        echo json_encode($reply);

        exit;

    }



    add_action('wp_ajax_nopriv_SH_Twitter_ajax_callback', 'SH_Twitter_ajax_callback');

    add_action('wp_ajax_SH_Twitter_ajax_callback', 'SH_Twitter_ajax_callback');



    function sh_related_projects() {

        global $post, $wp_query;



        $categories = get_the_terms($post->ID, 'project_category');



        if ($categories) {

            $category_ids = array();

            foreach ($categories as $individual_cat) {

                $category_ids[] = $individual_cat->term_id;

            }

            $args = array(

                'tax_query' => array(array('taxonomy' => 'project_category', 'field' => 'id', 'terms' => $category_ids)),

                'post__not_in' => array($post->ID),

                'posts_per_page' => -1,

                'post_type' => 'sh_project',

                'post_status' => 'publish'

            );



            $wp_query = new wp_query($args); //printr($wp_query);

            ?> 



            <section class="block remove-gap">

                <div class="container">

                    <div class="heading3">

                        <h2><i><?php _e('Related', 'wp_dastak') ?></i> <?php _e('Project', 'wp_dastak'); ?></h2>



                    </div>

                    <div id="related-project">

                        <div class="row bouncein">

                            <?php $i = 1; ?>

                            <?php while (have_posts()) : the_post(); ?> 

                                <?php $meta_settings = get_post_meta($post->ID, 'sh_project_option', true); //printr($meta_settings);?>



                                <div class="col-md-3">

                                    <div class="related-project">

                                        <div class="related-thumb">

                                            <?php the_post_thumbnail('284x216'); ?>

                                            <?php $day = date('d', strtotime(get_the_date())); ?>

                                            <?php $month = date('M', strtotime(get_the_date())); ?>

                                            <span><?php echo $day; ?><i><?php echo $month; ?></i></span>

                                            <a href="<?php the_permalink(); ?>" title=""><i class="fa fa-link"></i></a>

                                        </div>

                                        <h3><a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>"><?php echo character_limiter(get_the_title($post->ID), 25, '', true); ?></a></h3>

                                        <p><?php echo character_limiter(get_the_content($post->ID), 250, '', true); ?></p>

                                    </div>

                                </div>

                                <?php if ($i % 4 == 0): ?>

                                </div><div class="row">

                                <?php endif; ?>

                                <?php $i++; ?>

                            <?php endwhile; ?>

                        </div>

                    </div>

                </div>

            </section>  



            <?php

        }

        wp_reset_query();

    }



    function sh_related_portfolios() {

        global $post, $wp_query;



        $categories = get_the_terms($post->ID, 'portfolio_category');



        if ($categories) {

            $category_ids = array();

            foreach ($categories as $individual_cat) {

                $category_ids[] = $individual_cat->term_id;

            }

            $args = array(

                'tax_query' => array(array('taxonomy' => 'portfolio_category', 'field' => 'id', 'terms' => $category_ids)),

                'post__not_in' => array($post->ID),

                'posts_per_page' => -1,

                'post_type' => 'sh_portfolio',

                'post_status' => 'publish'

            );



            $wp_query = new wp_query($args); //printr($wp_query);

            ?> 



            <section class="block remove-gap">

                <div class="container">

                    <div class="heading3">

                        <h2><i><?php _e('Related', 'wp_dastak') ?></i> <?php _e('Project', 'wp_dastak'); ?></h2>



                    </div>

                    <div id="related-project">

                        <div class="row bouncein">

                            <?php $i = 1; ?>

                            <?php while (have_posts()) : the_post(); ?> 

                                <?php $meta_settings = get_post_meta($post->ID, 'sh_project_option', true); //printr($meta_settings); ?>



                                <div class="col-md-3">

                                    <div class="related-project">

                                        <div class="related-thumb">

                                            <?php the_post_thumbnail('284x216'); ?>

                                            <?php $day = date('d', strtotime(get_the_date())); ?>

                                            <?php $month = date('M', strtotime(get_the_date())); ?>

                                            <span><?php echo $day; ?><i><?php echo $month; ?></i></span>

                                            <a href="<?php the_permalink(); ?>" title=""><i class="fa fa-link"></i></a>

                                        </div>

                                        <h3><a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>"><?php echo character_limiter(get_the_title($post->ID), 25, '', true); ?></a></h3>

                                        <p><?php echo character_limiter(get_the_content($post->ID), 250, '', true); ?></p>

                                    </div>

                                </div>

                                <?php if ($i % 4 == 0): ?>

                                </div><div class="row">

                                <?php endif; ?>

                                <?php $i++; ?>

                            <?php endwhile; ?>

                        </div>

                    </div>

                </div>

            </section>  



            <?php

        }

        wp_reset_query();

    }



    function sh_related_services() {



        global $post, $wp_query;

        $settings = get_option('wp_dastak_theme_options');

        $categories = get_the_terms($post->ID, 'service_category');



        if ($categories) {

            $category_ids = array();

            foreach ($categories as $individual_cat) {

                $category_ids[] = $individual_cat->term_id;

            }

            $number  = (sh_set($settings, 'related_services_num')) ? sh_set($settings, 'related_services_num') : 3;

            $args = array(

                'tax_query' => array(array('taxonomy' => 'service_category', 'field' => 'id', 'terms' => $category_ids)),

                'post__not_in' => array($post->ID),

                'posts_per_page' => $number,

                'post_type' => 'sh_service',

                'post_status' => 'publish'

            );



            $wp_query = new wp_query($args);

            $cols = (sh_set($settings, 'related_services_cols')) ? sh_set($settings, 'related_services_cols') : '4';

            ?> 



            <section class="block remove-gap">

                <div class="container">

                    <div class="row">

                        <?php if(sh_set($settings, 'related_services_title')):?>

                            <div class="col-md-12">

                                <div class="heading3">



                                    <h2><?php echo sh_set($settings, 'related_services_title');?></h2>



                                </div>

                            </div>

                        <?php endif;?>

                        <?php while (have_posts()) : the_post(); ?> 

                            <?php

                            $meta = get_post_meta(get_the_id(), 'sh_services_option', true);

                            $font = sh_set($meta, 'fontawesome', 'icon-bar');

                            ?>

                            <div class="col-md-<?php echo $cols;?>">

                                <div class="service">

                                    <div class="row">

                                        <div class="col-md-3">

                                            <span><i class="fa <?php echo str_replace('icon-', 'fa-', $font); ?>"></i></span>

                                        </div>

                                        <div class="col-md-9">

                                            <h2><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>

                                            <p><?php echo character_limiter(get_the_content(), 150); ?></p>

                                            <a href="<?php the_permalink(); ?>" title=""><?php _e('View details', 'wp_dastak') ?> <i class="fa fa-angle-right"></i></a>

                                        </div>

                                    </div>

                                </div>

                            </div><!-- Service Box1 -->

                        <?php endwhile; ?>

                    </div>

                </div>

            </section>  



            <?php

        }

        wp_reset_query();

    }



    function sh_related_posts() {



        global $post, $wp_query;



        $categories = get_the_terms($post->ID, 'category');



        if ($categories) {

            $category_ids = array();

            foreach ($categories as $individual_cat) {

                $category_ids[] = $individual_cat->term_id;

            }

            $args = array(

                'tax_query' => array(array('taxonomy' => 'category', 'field' => 'id', 'terms' => $category_ids)),

                'post__not_in' => array($post->ID),

                'posts_per_page' => -1,

                'post_type' => 'post',

                'post_status' => 'publish'

            );



            $wp_query = new wp_query($args);

            ?> 





            <div class="single-project-sec">

                <div class="heading2">

                    <h2><i><?php _e('Related', 'wp_dastak'); ?></i> <?php _e('Posts', 'wp_dastak'); ?></h2>

                </div>

                <div id="related-project-sec">

                    <div class="row">

                        <?php $i = 1; ?>

                        <?php while (have_posts()) : the_post(); ?> 

                            <div class="col-md-4">

                                <div class="related-project">

                                    <div class="related-thumb">

                                        <?php the_post_thumbnail('284x216'); ?>

                                        <?php $day = date('d', strtotime(get_the_date())); ?>

                                        <?php $month = date('M', strtotime(get_the_date())); ?>

                                        <span><?php echo $day; ?><i><?php echo $month; ?></i></span>

                                        <a title="<?php the_title(); ?>" href="<?php the_permalink(); ?>"><i class="fa fa-link"></i></a>

                                    </div>

                                    <h3><a title="<?php the_title(); ?>" href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>

                                    <p><?php echo character_limiter(get_the_content(), 50); ?></p>

                                </div>

                            </div>

                            <?php if ($i % 3 == 0 && $wp_query->post_count !== $i): ?>

                            </div><div class="row">

                            <?php endif; ?>

                            <?php $i++; ?>

                        <?php endwhile; ?>

                    </div>

                </div>	

            </div>  



            <script type="text/javascript">

                jQuery(document).ready(function ($) {



                    $("#related-project-sec").owlCarousel({

                        autoPlay: true,

                        stopOnHover: true,

                        goToFirstSpeed: 2000,

                        slideSpeed: 1500,

                        singleItem: true,

                        autoHeight: true,

                        transitionStyle: "goDown",

                        navigation: true

                    });



                });

            </script>



            <?php

        }

        wp_reset_query();

    }



    function sh_get_attachment_id_from_src($image_src) {



        global $wpdb;

        $query = "SELECT ID FROM {$wpdb->posts} WHERE guid='$image_src'";



        $id = $wpdb->get_results($query);



        return (int) sh_set(sh_set($id, '0'), 'ID');

    }



    function sh_create_user($data) {

        if (!class_exists('PHPMailer'))

            include(ABSPATH . 'wp-includes/class-phpmailer.php');



        $random_password = wp_generate_password($length = 12, $include_standard_special_chars = false);

        $user_id = wp_create_user(sh_set($data, 'user_login'), $random_password, sh_set($data, 'user_email'));

        if (is_wp_error($user_id) && is_array($user_id->get_error_messages())) {

            foreach ($user_id->get_error_messages() as $message)

                echo '<p>' . $message . '</p>';

        } else {



            wp_new_user_notification($user_id, $random_password);

            echo '<p>' . __('Registration Successful - An email is sent', 'wp_dastak') . '</p>';

        }



        if (!is_wp_error($user_id)) {

            $userinfo = array(

                'ID' => $user_id,

                'first_name' => sh_set($_POST, 'first_name'),

                'last_name' => sh_set($_POST, 'last_name'),

            );



            wp_update_user($userinfo);

        }

    }



    function _WSH() {

        return $GLOBALS['_sh_base'];

    }



    function sh_get_rev_sliders() {

        global $wpdb;



        $table = $wpdb->get_results("SHOW TABLES LIKE '" . $wpdb->prefix . "revslider_sliders'", ARRAY_A);

        if (!$table)

            return array();



        $res = $wpdb->get_results("SELECT * FROM " . $wpdb->prefix . "revslider_sliders");



        $return = array();



        if ($res) {

            foreach ($res as $r) {

                $return[sh_set($r, 'alias')] = sh_set($r, 'title');

            }

        }

        return $return;

    }



    function sh_get_layer_sliders() {

        global $wpdb;

        $return = array();

        if (function_exists('layerslider')) {

            $sliders = $wpdb->get_results("SELECT * FROM " . $wpdb->prefix . "layerslider", ARRAY_A);



            if ($sliders) {

                foreach ($sliders as $r) {

                    $return[sh_set($r, 'id')] = sh_set($r, 'name');

                }

            }

        }

        return $return;

    }



    function sh_get_page_by_slug($slug) {

        $page = get_page_by_path($slug);

        if ($page) {

            return $page->ID;

        } else {

            return null;

        }

    }



    function sh_woocommerce_price_array($price) {



        $del = array('<span class="woocommerce-Price-amount amount">', '<span class="woocommerce-Price-currencySymbol">', '</span>', '<del>', '<ins>');

        $price = str_replace($del, '', $price);

        $price = str_replace('</del>', ' ', $price);

        $price = str_replace('</ins>', ' ', $price);

        $price_arr = explode(' ', $price);

        $price_arr = array_filter($price_arr);

        return $price_arr;

    }



    function _sh_trim($text, $len) {



        $text = strip_shortcodes($text);



        $text = apply_filters('the_content', $text);

        $text = str_replace(']]>', ']]&gt;', $text);



        $excerpt_length = apply_filters('excerpt_length', $len);



        $excerpt_more = apply_filters('excerpt_more', ' ' . '[&hellip;]');



        $text = wp_trim_words($text, $excerpt_length, $excerpt_more);



        return $text;

    }



    if (!function_exists('bistro_slug')) {



        function bistro_slug($string) {

            $string = str_replace(' ', '-', $string); // Replaces all spaces with hyphens.

            return preg_replace('/[^A-Za-z0-9\-]/', '', $string); // Removes special chars.

        }



    }



    function get_post_by_slug($slug) {

        $posts = get_posts(array(

            'name' => $slug,

            'posts_per_page' => 1,

            'post_type' => 'sh_jobs',

            'post_status' => 'publish'

        ));



        if (!$posts) {

            throw new Exception("NoSuchPostBySpecifiedID");

        }



        return $posts[0];

    }



    function sh_get_nav_menues() {

        $nav_menus = get_terms('nav_menu', array('hide_empty' => false));

        $custom_menus = array();

        foreach ($nav_menus as $nav_item) {

            $custom_menus[] = array('value' => $nav_item->slug, 'label' => $nav_item->name);

        }

        return $custom_menus;

    }



    function sh_houre_range() {

        $value = range(0, 100);

        $return = array();

        foreach ($value as $val) {

            $return[] = array('value' => $val, 'label' => $val . ' Hour');

        }

        return $return;

    }