<?php

class SH_Mega_Menu_Shortcodes {

    protected $keys;

    function __construct() {
        $this->add();
    }

    function add() {

        $options = array('megamenu_container_shortcode', 'custom_menu_shortcode', 'custom_content_shortcode', 'custom_carousel_shortcode');

        $this->keys = $options;
        foreach ($this->keys as $k) {
            if (method_exists($this, $k))
                add_shortcode($k, array($this, $k));
        }
    }

    function megamenu_container_shortcode($atts, $content = null) {
        extract(shortcode_atts(array(
            'imageleft' => '',
            'imageright' => '',
            'style' => 'style1',
            'position' => '',
            'color' => '',
                        ), $atts));

        $output = '';
        $background='';
        if ($imageleft && $imageright) {
            $background = 'style="background-image:url(' . $imageleft . '), url(' . $imageright . ');"';
        } elseif ($imageright) {
            $background = 'style="background-image:url(' . $imageright . ');background-position:top right;"';
        } elseif ($imageleft) {
            $background = 'style="background-image:url(' . $imageleft . ');"';
        }
        $output .= '<div class="mega-menu ' . $style . ' ' . $position . ' ' . $color . '" ' . $background . '>
                    <div class="row">';
        $output .= do_shortcode($content);
        $output .= '</div></div>';

        return $output;
    }

    function custom_menu_shortcode($atts, $content = null) {
        extract(shortcode_atts(array(
            'title' => '',
            'cols' => '3',
            'menu' => '',
                        ), $atts));

        $output = '';

        $output .= '<div class="col-md-' . $cols . '">
						<div class="drop-menu">';
        $output .= ($title) ? '<h3>' . $title . '</h3>' : '';
        $output .= ($menu) ? wp_nav_menu(array('menu' => $menu, 'echo' => false, 'container' => false)) : '';
        $output .= '</div>
					</div>';

        return $output;
    }

    function custom_content_shortcode($atts, $content = null) {
        extract(shortcode_atts(array(
            'title' => '',
            'description' => '',
            'cols' => '3',
            'label' => '',
            'url' => '',
                        ), $atts));

        $output = '';

        $output .= '<div class="col-md-' . $cols . '">
						<div class="about-2">';
        $output .= ($title) ? '<h3>' . $title . '</h3>' : '';
        $output .= ($description) ? '<p>' . $description . '</p>' : '';
        $output .= ($label) ? '<a href="' . $url . '">' . $label . '</a>' : '';
        $output .= '</div>
					</div>';

        return $output;
    }

    function custom_carousel_shortcode($atts) {
        extract(shortcode_atts(array(
            'title' => '',
            'cols' => 3,
            'num' => 3,
            'post_type' => 'post'
                        ), $atts));

        $args = array('post_type' => $post_type, 'showposts' => $num, 'order' => 'DESC');
        //if( $cat ) $args['tax_query'] = array(array('taxonomy' => 'category','field' => 'id','terms' => $cat));
        query_posts($args);


        $output = '<div class="col-md-' . $cols . '">
					<div class="menu-slides">
						<h3>' . $title . '</h3>
						<ul class="menu-slide">';
        while (have_posts()):the_post();
            $output .='<li>' . get_the_post_thumbnail(get_the_ID(), '370x370') . '
									<div class="menu-slide-desc">
										<h3>' . get_the_title() . '</h3>
										
									</div>
								</li>';
        endwhile;

        $output .='</ul>
				</div>';
        $output .='<script type="text/javascript">
					jQuery(document).ready(function($) {
					
					$(".menu-slide").owlCarousel({
						autoPlay :true,
						stopOnHover : true,
						goToFirstSpeed : 2000,
						slideSpeed:1500,
						singleItem : true,
						autoHeight : true,
						transitionStyle:"backSlide",
						navigation:false,
						pagination: false
					});	
						
					});
				</script>';
        $output .='</div>';
        wp_reset_query();
        return $output;
    }

}

?>