<?php

class SH_Enqueue {

    function __construct() {
        add_action('wp_enqueue_scripts', array($this, 'sh_enqueue_scripts'));

        add_action('wp_head', array($this, 'wp_head'));

        add_action('wp_footer', array($this, 'wp_footer'));
    }

    function sh_enqueue_scripts() {
        //echo 'wp_dastak';
        $options = get_option('wp_dastak' . '_theme_options'); //printr($options);
        $protocol = is_ssl() ? 'https' : 'http';
        $fl_array = preg_grep("/_font_family/", array_keys($options)); //printr($fl_array);
        $google_fonts = $this->google_fonts($options, $fl_array); //printr($google_fonts);
        $font_family = ( sh_set($options, 'logo_font_face')) ? sh_set($options, 'logo_font_face') . ':400,100,300,700|' : '';
        $styles = array(
            'google_fonts' => $protocol . '://fonts.googleapis.com/css?family=Lato:400,100,300,700,900|' . $font_family . $google_fonts,
            'google_fonts_roboto' => $protocol . '://fonts.googleapis.com/css?family=Roboto:400,300,500,700',
            'google_fonts_roboto_condensed' => $protocol . '://fonts.googleapis.com/css?family=Roboto+Condensed:200,400,300,700,900',
            'main_style' => 'css/style.css', 
            'font-awesome' => 'font-awesome/css/font-awesome.css', 
            'animate' => 'css/animate.css', 
            'bootstrap-min' => 'css/bootstrap.min.css', 
            'jquery-mCustomScrollbar' => 'css/jquery.mCustomScrollbar.css', 
            'jsDatePick_ltr-min' => 'css/jsDatePick_ltr.min.css', 
            'owl-carousel' => 'css/owl.carousel.css', 
            'idangerous-swiper' => 'css/idangerous.swiper.css');


        //$res_settings = sh_header_settings($options);

        $styles['responsive'] = 'css/responsive.css';
        foreach ($styles as $name => $style) {
            
            if (strstr($style, $protocol))
                wp_enqueue_style($name, $style);
            else
                wp_enqueue_style($name, SH_URL . $style);
            
        }

        $rtl_settings = get_option('wp_dastak' . '_theme_options');
        if (sh_set($rtl_settings, 'site_rtl'))
            wp_enqueue_style('site-rtl', SH_URL . 'css/rtl.css');

        $scripts = array(  
            'bootstrap_min' => 'bootstrap.min.js', 
            'modernizr' => 'modernizr.js', 
            'script-login' => 'script-login.js', 
            'owl-carousel-min' => 'owl.carousel.min.js', 
            'onscreen' => 'onscreen.js',
            'switcher' => 'switcher.js',
             'scrolltopcontrol' => 'scrolltopcontrol.js',
              'jquery-mCustomScrollbar-concat-min' => 'jquery.mCustomScrollbar.concat.min.js',
            'jquery-themepunch-plugins-min' => 'jquery.themepunch.plugins.min.js',
             'html5lightbox' => 'html5lightbox.js', 
             'countdown' => 'countdown.js', 
             'decrement' => 'decrement.js',
            'form-element' => 'form-element.js', 
            'jquery-downCount' => 'jquery.downCount.js',
             'jquery-isotope' => 'jquery.isotope.js', 
             'jquery-jigowatt' => 'jquery.jigowatt.js',
              'jquery-counterup' => 'jquery.counterup.js',
               'waypoints' => 'waypoints.js',
            'jsDatePick-min' => 'jsDatePick.min.1.3.js', 
            'masonary' => 'masonary.js', 
            'timer' => 'timer.js', 
            'flickr' => 'jflickrfeed.min.js',
            'custom-tweets' => 'custom_tweets.js', 
            'jquery-circliful' => 'jquery.circliful.js',
            'dangerous-swip' => 'idangerous.swiper-2.1.min.js',
            'increment-sript' => 'userincr.js', 
            'custom-script' => 'script.js',
            'recaptcha' => 'https://www.google.com/recaptcha/api.js', 
               
          );

        foreach ($scripts as $name => $js) {
      

            if ( strstr( $js, 'http' ) || strstr( $js, 'https' )  ) {
                wp_register_script( $name, $js, '', '', true );
            } else {
                wp_register_script($name, SH_URL . 'js/' . $js, '', '', true);
            }
        }
    
        $scrolltopcontrol  = ( sh_set($options, 'page_up_anchor' ) ) ? 'scrolltopcontrol'  : '';
        wp_enqueue_script(array('jquery', 'bootstrap_min', 'script-login', 'modernizr', 'owl-carousel-min', 'onscreen', $scrolltopcontrol, 'html5lightbox', 'jquery-isotope', 'masonary', 'custom-tweets', 'custom-script'));


        /* wp_enqueue_script(array('jquery', 'jquery-effects-core', 'jquery-effects-blind', 'bootstrap_min', 'modernizr',  'owl-carousel-min', 'onscreen', 'switcher', 'scrolltopcontrol' ,'jquery-mCustomScrollbar-concat-min'  , 'html5lightbox', 'countdown', 'decrement', 'form-element', 'jquery-downCount', 'jquery-isotope', 'jquery-jigowatt', 'jsDatePick-min', 'masonary', 'timer','jquery-themepunch-revolution-min','flickr', 'custom-tweets' ));
         */

        /* if( is_page_template( 'tpl-portfolio.php' ) || is_singular('dict_gallery') ) wp_enqueue_script( array('html5lightbox', 'prettyPhoto') ); */
      

            wp_localize_script( 'script-login', 'sh_login_form_object', array(
            'loadingmessage' => esc_html__( 'Sending user info, please wait...', 'wp_ducan' )
        ) );
        if (is_singular() || is_single())
            wp_enqueue_script(array('comment-reply'));
    }

    function wp_head() {
        $settings = get_option('wp_dastak' . '_theme_options');
        echo '<script type="text/javascript"> if( ajaxurl === undefined ) var ajaxurl = "' . admin_url('admin-ajax.php') . '"; var theme_url = "' . get_template_directory_uri() . '";</script>';
        ?>	
        <?php if (sh_set($settings, 'sticky_menu')): ?>
            <script type="text/javascript">
                jQuery(document).ready(function ($) {
                    /*** FIXED Menu APPEARS ON SCROLL DOWN ***/
                    $(window).scroll(function () {
                        var scroll = $(window).scrollTop();
                        if (scroll >= 50) {
                            $("#menu-sec").addClass("sticky");
                        }
                        else {
                            $("#menu-sec").removeClass("sticky");
                            $("#menu-sec").addClass("");
                        }
                    });
                });
            </script>
        <?php endif; ?>
        
        <style type="text/css">
        <?php
        if (sh_set($settings, 'body_custom_font') == 1) : 
            echo sh_get_font_settings(array('body_font_family' => 'font-family', 'body_font_size' => 'font-size', 'body_font_color' => 'color'), '.post-desc p, .page-description p {', '}');
        endif;
        if (sh_set($settings, 'use_custom_font') == 1):
            echo sh_get_font_settings(array('h1_font_family' => 'font-family', 'h1_font_color' => 'color', 'h1_font_size' => 'font-size'), '.post-desc h1, .post-desc h1 > a, .page-description h1, .page-description h1 > a {', '}');
            echo sh_get_font_settings(array('h2_font_family' => 'font-family', 'h2_font_color' => 'color', 'h2_font_size' => 'font-size'), '.post-desc h2, .post-desc h2 > a, .page-description h2, .page-description h2 > a {', '}');
            echo sh_get_font_settings(array('h3_font_family' => 'font-family', 'h3_font_color' => 'color', 'h3_font_size' => 'font-size'), '.post-desc h3, .post-desc h3 > a, .page-description h3, .page-description h3 > a {', '}');
            echo sh_get_font_settings(array('h4_font_family' => 'font-family', 'h4_font_color' => 'color', 'h4_font_size' => 'font-size'), '.post-desc h4, .post-desc h4 > a, .page-description h4, .page-description h4 > a {', '}');
            echo sh_get_font_settings(array('h5_font_family' => 'font-family', 'h5_font_color' => 'color', 'h5_font_size' => 'font-size'), '.post-desc h5, .post-desc h5 > a, .page-description h5, .page-description h5 > a {', '}');
            echo sh_get_font_settings(array('h6_font_family' => 'font-family', 'h6_font_color' => 'color', 'h6_font_size' => 'font-size'), '.post-desc h6, .post-desc h6 > a, .page-description h6, .page-description h6 > a {', '}');


        endif;
        ?>
        <?php echo $custom_css = sh_set($settings, 'header_css'); ?>
        </style>

        <?php
        echo sh_theme_color_scheme();
    }

    function wp_footer() {
        $settings = get_option('wp_dastak' . '_theme_options');
        //printr(sh_header_settings($settings));



        echo ( isset($settings['footer_analytics']) && !empty($settings['footer_analytics']) ) ? stripslashes($settings['footer_analytics']) : '';
    }

    function google_fonts($options, $fonts = array()) {
        if (!$fonts || !is_array($fonts))
            return '';

        //$styles = $fl_array = preg_grep("/_font_style/", array_keys($options));//printr($fl_array);

        $google_fonts = array();
        foreach ($fonts as $f) {
            $val = sh_set($options, $f);
            $style = sh_set($options, str_replace('_font_family', '_font_style', $f));
            $style = ( $style ) ? ':' . $style : '';
            if ($val)
                $google_fonts[$val] = str_replace(' ', '+', $val . ':300,400,500,700') . $style;
        }

        if ($google_fonts)
            return implode('|', $google_fonts);
        else
            return '';
    }

}