<?php

/*get_template_part('includes/library/form_helper');
get_template_part('includes/enqueue');
get_template_part('includes/helpers/post_types');
get_template_part('includes/helpers/meta_boxes');
get_template_part('includes/helpers/functions');
get_template_part('includes/helpers/widgets');
*/

class SH_Base
{
	protected $_cache_group = '';
	protected $_cache = '';
	
	function __construct()
	{
		
		$this->_cache_group = '_sh_cache_group';
		
		$this->_cache = get_transient($this->_cache_group);
	}
	
	/**
	 * enqueue styles/js for theme page
	 *
	 * @since NHP_Options 1.0
	*/
	function _fields_enqueue($settings = array(), $data){
		
			$element = array();
			if($settings){
				
				foreach( $settings as $fieldk => $field){
					//print_r($field);exit;
					$element[] = $this->_generate_html($fieldk, $field, $data);
					
				}//foreach
			
			}//if fields
			
	
			return $element;
		
	}//function
	
	function _generate_html($name, $field, $settings)
	{
		
		$return = array();
		
		$value = (sh_set( $settings, $name ) ) ? sh_set($settings, $name ) : sh_set( $field, 'std');
		$attributes = $this->set_attrib(sh_set($field, 'attributes'));
		
		switch( sh_set( $field, 'type' ) )
		{
			case 'select':
				$return['field'] = form_dropdown( $name, sh_set($field, 'options'), $value, $attributes );
			break;
			case 'date':
				$return['field'] = form_input( $name, $value, $attributes );
				$return['field'] .= '<script type="text/javascript">jQuery(document).ready(function($){$(\'input[name="'.$name.'"]\').datepicker();});</script>'; 
			/*case 'time':
				echo "Hello";exit;
			$return['field'] = form_input( $name, $value, $attributes );
			$return['field'] .= '<script type="text/javascript">jQuery(document).ready(function($){$(\'.vp-js-timepicker\').timepicker();});</script>';   */
			break;
		}
		
		$return['title'] = sh_set($field, 'title');
		
		return $return;
	}
	
	
	function set_attrib( $attr = array() )
	{
		$res = ' ';
		foreach( $attr as $k => $v )
		{
			$res .= $k.'="'.$v.'" ';
		}
		
		return $res;
	}
	
	function set_term_key( $post_type )
	{
		if( ! $post_type ) return;
		
		return '_sh_'.$post_type.'_settings';
		
	}
	
	function option( $key = '' )
	{
		$theme_options = get_option( 'wp_dastak'.'_theme_options' );
		
		if( $key ) return sh_set( $theme_options, $key );
		
		return $theme_options;
	}
	
	function page_template( $tpl )
	{
		$page = get_pages(array('meta_key' => '_wp_page_template','meta_value' => $tpl));
		if($page) return current( (array)$page);
		else return false;
	}

}

$GLOBALS['_sh_base'] = new SH_Base;

